/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.factory.primitive.FloatSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSingletonSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

@Immutable
final class ImmutableFloatEmptySet
implements ImmutableFloatSet,
Serializable {
    static final ImmutableFloatSet INSTANCE = new ImmutableFloatEmptySet();
    private static final long serialVersionUID = 1L;

    ImmutableFloatEmptySet() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableFloatSet newWith(float element) {
        return new ImmutableFloatSingletonSet(element);
    }

    public ImmutableFloatSet newWithout(float element) {
        return this;
    }

    public ImmutableFloatSet newWithAll(FloatIterable elements) {
        return FloatSets.immutable.withAll(elements);
    }

    public ImmutableFloatSet newWithoutAll(FloatIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(float value) {
        return false;
    }

    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(float ... elements) {
        return elements.length == 0;
    }

    public void forEach(FloatProcedure procedure) {
    }

    public void each(FloatProcedure procedure) {
    }

    public ImmutableFloatSet select(FloatPredicate predicate) {
        return this;
    }

    public ImmutableFloatSet reject(FloatPredicate predicate) {
        return this;
    }

    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return Sets.immutable.of();
    }

    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    public int count(FloatPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    public double sum() {
        return 0.0;
    }

    public float min() {
        throw new NoSuchElementException();
    }

    public float max() {
        throw new NoSuchElementException();
    }

    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public float[] toSortedArray() {
        return new float[0];
    }

    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FloatSet)) {
            return false;
        }
        FloatSet set = (FloatSet)obj;
        return set.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    public FloatSet freeze() {
        return this;
    }

    public ImmutableFloatSet toImmutable() {
        return this;
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public float[] toArray() {
        return new float[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }
}

