/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.field.decorator;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class RuntimeExceptionShield
implements InvocationHandler {
    private static final Map<Class<?>, Object> DEFAULT_RETURN_VALUES = new HashMap();
    private final Object target;
    private final Class<?> exceptionClass;

    public RuntimeExceptionShield(Object target, Class<?> exceptionClass) {
        DEFAULT_RETURN_VALUES.put(Byte.TYPE, 0);
        DEFAULT_RETURN_VALUES.put(Short.TYPE, 0);
        DEFAULT_RETURN_VALUES.put(Integer.TYPE, 0);
        DEFAULT_RETURN_VALUES.put(Long.TYPE, 0L);
        DEFAULT_RETURN_VALUES.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULT_RETURN_VALUES.put(Double.TYPE, 0.0);
        DEFAULT_RETURN_VALUES.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULT_RETURN_VALUES.put(Boolean.TYPE, false);
        this.target = target;
        this.exceptionClass = exceptionClass;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.target, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause().getClass() != this.exceptionClass) {
                throw e.getCause();
            }
            return DEFAULT_RETURN_VALUES.get(method.getReturnType());
        }
    }
}

