/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web;

import java.util.HashMap;
import java.util.Map;
import org.springframework.security.web.PortMapper;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortMapperImpl
implements PortMapper {
    private final Map<Integer, Integer> httpsPortMappings = new HashMap<Integer, Integer>();

    public PortMapperImpl() {
        this.httpsPortMappings.put(80, 443);
        this.httpsPortMappings.put(8080, 8443);
    }

    public Map<Integer, Integer> getTranslatedPortMappings() {
        return this.httpsPortMappings;
    }

    @Override
    public Integer lookupHttpPort(Integer httpsPort) {
        for (Integer httpPort : this.httpsPortMappings.keySet()) {
            if (!this.httpsPortMappings.get(httpPort).equals(httpsPort)) continue;
            return httpPort;
        }
        return null;
    }

    @Override
    public Integer lookupHttpsPort(Integer httpPort) {
        return this.httpsPortMappings.get(httpPort);
    }

    public void setPortMappings(Map<String, String> newMappings) {
        Assert.notNull(newMappings, "A valid list of HTTPS port mappings must be provided");
        this.httpsPortMappings.clear();
        for (Map.Entry<String, String> entry : newMappings.entrySet()) {
            Integer httpPort = Integer.valueOf(entry.getKey());
            Integer httpsPort = Integer.valueOf(entry.getValue());
            if (httpPort < 1 || httpPort > 65535 || httpsPort < 1 || httpsPort > 65535) {
                throw new IllegalArgumentException("one or both ports out of legal range: " + httpPort + ", " + httpsPort);
            }
            this.httpsPortMappings.put(httpPort, httpsPort);
        }
        if (this.httpsPortMappings.size() < 1) {
            throw new IllegalArgumentException("must map at least one port");
        }
    }
}

