/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.math.BigDecimal;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;
import org.springframework.util.NumberUtils;

public class OpLT
extends Operator {
    public OpLT(int pos, SpelNodeImpl ... operands) {
        super("<", pos, operands);
    }

    @Override
    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        Object left = this.getLeftOperand().getValueInternal(state).getValue();
        Object right = this.getRightOperand().getValueInternal(state).getValue();
        if (left instanceof Number && right instanceof Number) {
            Number leftNumber = (Number)left;
            Number rightNumber = (Number)right;
            if (leftNumber instanceof BigDecimal || rightNumber instanceof BigDecimal) {
                BigDecimal rightBigDecimal;
                BigDecimal leftBigDecimal = NumberUtils.convertNumberToTargetClass(leftNumber, BigDecimal.class);
                return BooleanTypedValue.forValue(leftBigDecimal.compareTo(rightBigDecimal = NumberUtils.convertNumberToTargetClass(rightNumber, BigDecimal.class)) < 0);
            }
            if (leftNumber instanceof Double || rightNumber instanceof Double) {
                return BooleanTypedValue.forValue(leftNumber.doubleValue() < rightNumber.doubleValue());
            }
            if (leftNumber instanceof Float || rightNumber instanceof Float) {
                return BooleanTypedValue.forValue(leftNumber.floatValue() < rightNumber.floatValue());
            }
            if (leftNumber instanceof Long || rightNumber instanceof Long) {
                return BooleanTypedValue.forValue(leftNumber.longValue() < rightNumber.longValue());
            }
            return BooleanTypedValue.forValue(leftNumber.intValue() < rightNumber.intValue());
        }
        if (left instanceof CharSequence && right instanceof CharSequence) {
            left = left.toString();
            right = right.toString();
        }
        return BooleanTypedValue.forValue(state.getTypeComparator().compare(left, right) < 0);
    }
}

