/*
 * Decompiled with CFR 0.152.
 */
package org.duracloud.common.util.metrics;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.duracloud.common.util.metrics.Metric;
import org.duracloud.common.util.metrics.MetricException;

public class MetricsTable {
    private final LinkedHashMap<Metric, Map<Metric.MetricElement, MetricsTable>> table = new LinkedHashMap();

    public void addMetric(Metric metric) {
        this.table.put(metric, new HashMap());
    }

    public void addSubMetric(Metric parent, MetricsTable subTable) {
        this.table.get(parent).put(parent.currentElement(), subTable);
    }

    public Iterator<Metric> getMetrics() {
        return this.table.keySet().iterator();
    }

    public Iterator<Metric.MetricElement> getElements(Metric parent) {
        return parent.getElements();
    }

    public MetricsTable getSubTable(Metric parent, Metric.MetricElement elem) throws MetricException {
        if (!this.table.containsKey(parent)) {
            throw new MetricException("No parent metric found: " + parent.toString());
        }
        if (!this.table.get(parent).containsKey(elem)) {
            throw new MetricException("No element found for parent metric: " + elem.toString() + " | " + parent.toString());
        }
        return this.table.get(parent).get(elem);
    }
}

