/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.WorkspaceRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateWorkspacesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<WorkspaceRequest> workspaces;

    public List<WorkspaceRequest> getWorkspaces() {
        if (this.workspaces == null) {
            this.workspaces = new SdkInternalList();
        }
        return this.workspaces;
    }

    public void setWorkspaces(Collection<WorkspaceRequest> workspaces) {
        if (workspaces == null) {
            this.workspaces = null;
            return;
        }
        this.workspaces = new SdkInternalList<WorkspaceRequest>(workspaces);
    }

    public CreateWorkspacesRequest withWorkspaces(WorkspaceRequest ... workspaces) {
        if (this.workspaces == null) {
            this.setWorkspaces(new SdkInternalList<WorkspaceRequest>(workspaces.length));
        }
        for (WorkspaceRequest ele : workspaces) {
            this.workspaces.add(ele);
        }
        return this;
    }

    public CreateWorkspacesRequest withWorkspaces(Collection<WorkspaceRequest> workspaces) {
        this.setWorkspaces(workspaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getWorkspaces() != null) {
            sb.append("Workspaces: " + this.getWorkspaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkspacesRequest)) {
            return false;
        }
        CreateWorkspacesRequest other = (CreateWorkspacesRequest)obj;
        if (other.getWorkspaces() == null ^ this.getWorkspaces() == null) {
            return false;
        }
        return other.getWorkspaces() == null || other.getWorkspaces().equals(this.getWorkspaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getWorkspaces() == null ? 0 : this.getWorkspaces().hashCode());
        return hashCode;
    }

    @Override
    public CreateWorkspacesRequest clone() {
        return (CreateWorkspacesRequest)super.clone();
    }
}

