/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateSnapshotCopyGrantRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateSnapshotCopyGrantRequestMarshaller
implements Marshaller<Request<CreateSnapshotCopyGrantRequest>, CreateSnapshotCopyGrantRequest> {
    @Override
    public Request<CreateSnapshotCopyGrantRequest> marshall(CreateSnapshotCopyGrantRequest createSnapshotCopyGrantRequest) {
        if (createSnapshotCopyGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateSnapshotCopyGrantRequest> request = new DefaultRequest<CreateSnapshotCopyGrantRequest>(createSnapshotCopyGrantRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateSnapshotCopyGrant");
        request.addParameter("Version", "2012-12-01");
        if (createSnapshotCopyGrantRequest.getSnapshotCopyGrantName() != null) {
            request.addParameter("SnapshotCopyGrantName", StringUtils.fromString(createSnapshotCopyGrantRequest.getSnapshotCopyGrantName()));
        }
        if (createSnapshotCopyGrantRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(createSnapshotCopyGrantRequest.getKmsKeyId()));
        }
        List<Tag> tagsList = createSnapshotCopyGrantRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

