/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.redshift.model.CreateClusterSnapshotRequest;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class CreateClusterSnapshotRequestMarshaller
implements Marshaller<Request<CreateClusterSnapshotRequest>, CreateClusterSnapshotRequest> {
    @Override
    public Request<CreateClusterSnapshotRequest> marshall(CreateClusterSnapshotRequest createClusterSnapshotRequest) {
        if (createClusterSnapshotRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateClusterSnapshotRequest> request = new DefaultRequest<CreateClusterSnapshotRequest>(createClusterSnapshotRequest, "AmazonRedshift");
        request.addParameter("Action", "CreateClusterSnapshot");
        request.addParameter("Version", "2012-12-01");
        if (createClusterSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString(createClusterSnapshotRequest.getSnapshotIdentifier()));
        }
        if (createClusterSnapshotRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString(createClusterSnapshotRequest.getClusterIdentifier()));
        }
        List<Tag> tagsList = createClusterSnapshotRequest.getTags();
        int tagsListIndex = 1;
        for (Tag tagsListValue : tagsList) {
            Tag tagMember = tagsListValue;
            if (tagMember != null) {
                if (tagMember.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagMember.getKey()));
                }
                if (tagMember.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagMember.getValue()));
                }
            }
            ++tagsListIndex;
        }
        return request;
    }
}

