/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SourceConfigurationStaxUnmarshaller
implements Unmarshaller<SourceConfiguration, StaxUnmarshallerContext> {
    private static SourceConfigurationStaxUnmarshaller instance;

    @Override
    public SourceConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        SourceConfiguration sourceConfiguration = new SourceConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sourceConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ApplicationName", targetDepth)) {
                    sourceConfiguration.setApplicationName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("TemplateName", targetDepth)) continue;
                sourceConfiguration.setTemplateName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sourceConfiguration;
    }

    public static SourceConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SourceConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

