/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeExportTasksRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeExportTasksRequestMarshaller
implements Marshaller<Request<DescribeExportTasksRequest>, DescribeExportTasksRequest> {
    @Override
    public Request<DescribeExportTasksRequest> marshall(DescribeExportTasksRequest describeExportTasksRequest) {
        if (describeExportTasksRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeExportTasksRequest> request = new DefaultRequest<DescribeExportTasksRequest>(describeExportTasksRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeExportTasks");
        request.addParameter("Version", "2015-04-15");
        List<String> exportTaskIdsList = describeExportTasksRequest.getExportTaskIds();
        int exportTaskIdsListIndex = 1;
        for (String exportTaskIdsListValue : exportTaskIdsList) {
            if (exportTaskIdsListValue != null) {
                request.addParameter("ExportTaskId." + exportTaskIdsListIndex, StringUtils.fromString(exportTaskIdsListValue));
            }
            ++exportTaskIdsListIndex;
        }
        return request;
    }
}

