/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.util.json.JSONWriter;
import java.util.List;

public class ProjectionJsonMarshaller {
    private static ProjectionJsonMarshaller instance;

    public void marshall(Projection projection, JSONWriter jsonWriter) {
        if (projection == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> nonKeyAttributesList;
            jsonWriter.object();
            if (projection.getProjectionType() != null) {
                jsonWriter.key("ProjectionType").value(projection.getProjectionType());
            }
            if ((nonKeyAttributesList = projection.getNonKeyAttributes()) != null) {
                jsonWriter.key("NonKeyAttributes");
                jsonWriter.array();
                for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                    if (nonKeyAttributesListValue == null) continue;
                    jsonWriter.value(nonKeyAttributesListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ProjectionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ProjectionJsonMarshaller();
        }
        return instance;
    }
}

