/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.codedeploy.model.DeploymentConfigInfo;
import com.amazonaws.services.codedeploy.model.transform.MinimumHealthyHostsJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DeploymentConfigInfoJsonMarshaller {
    private static DeploymentConfigInfoJsonMarshaller instance;

    public void marshall(DeploymentConfigInfo deploymentConfigInfo, JSONWriter jsonWriter) {
        if (deploymentConfigInfo == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (deploymentConfigInfo.getDeploymentConfigId() != null) {
                jsonWriter.key("deploymentConfigId").value(deploymentConfigInfo.getDeploymentConfigId());
            }
            if (deploymentConfigInfo.getDeploymentConfigName() != null) {
                jsonWriter.key("deploymentConfigName").value(deploymentConfigInfo.getDeploymentConfigName());
            }
            if (deploymentConfigInfo.getMinimumHealthyHosts() != null) {
                jsonWriter.key("minimumHealthyHosts");
                MinimumHealthyHostsJsonMarshaller.getInstance().marshall(deploymentConfigInfo.getMinimumHealthyHosts(), jsonWriter);
            }
            if (deploymentConfigInfo.getCreateTime() != null) {
                jsonWriter.key("createTime").value(deploymentConfigInfo.getCreateTime());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DeploymentConfigInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DeploymentConfigInfoJsonMarshaller();
        }
        return instance;
    }
}

