/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http.logging;

import org.concordion.cubano.driver.http.HttpEasyDefaults;
import org.concordion.cubano.driver.http.LogWriter;
import org.concordion.cubano.driver.http.logging.LogBuffer;

public class LogManager {
    private boolean logRequest;
    private boolean logRequestDetails;
    private LogWriter logWriter;
    private LogBuffer logBuffer = null;

    public LogManager(LogWriter logWriter, boolean logRequestDetails) {
        if (logWriter == null) {
            this.logRequest = false;
            this.logRequestDetails = false;
        } else {
            this.logRequest = HttpEasyDefaults.getLogRequest() || logRequestDetails;
            this.logRequestDetails = logRequestDetails;
        }
        this.logWriter = logWriter;
    }

    public boolean isLogRequestDetails() {
        return this.logRequestDetails;
    }

    public void info(String msg, Object ... args) {
        if (this.logWriter == null) {
            return;
        }
        if (this.logRequest) {
            this.logWriter.info(msg, args);
        }
    }

    public void error(String message, Throwable t) {
        if (this.logWriter == null) {
            return;
        }
        this.logWriter.error(message, t);
    }

    public void flushInfo() {
        if (this.logWriter != null && this.logRequest && this.logBuffer != null && this.logBuffer.length() > 0) {
            String[] lines;
            this.logBuffer.trimNewLine();
            for (String line : lines = this.logBuffer.toString().split("\\r?\\n")) {
                this.logWriter.info(line, new Object[0]);
            }
        }
        this.logBuffer = null;
    }

    public void flushRequest() {
        if (this.logWriter != null && this.logRequestDetails && this.logBuffer != null && this.logBuffer.length() > 0) {
            this.logBuffer.trimNewLine();
            this.logWriter.request(this.logBuffer.toString(), new Object[0]);
        }
        this.logBuffer = null;
    }

    public void flushResponse() {
        if (this.logWriter != null && this.logRequestDetails && this.logBuffer != null && this.logBuffer.length() > 0) {
            this.logBuffer.trimNewLine();
            this.logWriter.response(this.logBuffer.toString(), new Object[0]);
        }
        this.logBuffer = null;
    }

    public LogBuffer getBuffer() {
        if (this.logBuffer == null) {
            this.logBuffer = new LogBuffer();
        }
        return this.logBuffer;
    }
}

