/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import com.github.markusbernhardt.proxy.util.Logger;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class ProxyVoleLogger
implements Logger.LogBackEnd {
    private static final Map<Logger.LogLevel, LoggingFunction> map = new HashMap<Logger.LogLevel, LoggingFunction>();

    public void log(Class<?> clazz, Logger.LogLevel loglevel, String msg, Object ... params) {
        map.get(loglevel).log(clazz, this.removePositionalCharacter(msg), params);
    }

    private String removePositionalCharacter(String msg) {
        return msg.replaceAll("\\{([0-9]+)\\}", "{}");
    }

    static {
        map.put(Logger.LogLevel.TRACE, (c, m, p) -> LoggerFactory.getLogger((Class)c).trace(m, p));
        map.put(Logger.LogLevel.DEBUG, (c, m, p) -> LoggerFactory.getLogger((Class)c).debug(m, p));
        map.put(Logger.LogLevel.INFO, (c, m, p) -> LoggerFactory.getLogger((Class)c).info(m, p));
        map.put(Logger.LogLevel.WARNING, (c, m, p) -> LoggerFactory.getLogger((Class)c).warn(m, p));
        map.put(Logger.LogLevel.ERROR, (c, m, p) -> LoggerFactory.getLogger((Class)c).error(m, p));
    }

    @FunctionalInterface
    private static interface LoggingFunction {
        public void log(Class<?> var1, String var2, Object ... var3);
    }
}

