/*
 * Decompiled with CFR 0.152.
 */
package org.concordion.cubano.driver.http;

import com.github.markusbernhardt.proxy.ProxySearch;
import com.github.markusbernhardt.proxy.util.Logger;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.concordion.cubano.driver.http.LogWriter;
import org.concordion.cubano.driver.http.ProxyConfiguration;
import org.concordion.cubano.driver.http.ProxyVoleLoggerFactory;
import org.concordion.cubano.driver.http.logging.LoggerLogWriter;

public class HttpEasyDefaults {
    public static final String DEFAULT_PROXY_BYPASS_HOSTS = "localhost,127.0.0.1";
    private static String baseUrl = "";
    private static boolean trustAllCertificates = false;
    private static boolean trustAllHosts = false;
    private static List<String> sensitiveParameters = new ArrayList<String>();
    private static String authUser = null;
    private static String authPassword = null;
    private static ProxyConfiguration proxyConfiguration = ProxyConfiguration.MANUAL;
    private static volatile ProxySelector proxySearch = null;
    private static Proxy proxy = Proxy.NO_PROXY;
    private static String proxyUser = null;
    private static String proxyPassword = null;
    private static boolean bypassProxy = false;
    private static List<String> nonProxyHosts = HttpEasyDefaults.splitHosts("localhost,127.0.0.1");
    private static LogWriter defaultLogWriter = new LoggerLogWriter();
    private static boolean logRequest = true;
    private static boolean logRequestDetails = false;

    public HttpEasyDefaults trustAllCertificates(boolean trustAllCertificates) {
        HttpEasyDefaults.trustAllCertificates = trustAllCertificates;
        return this;
    }

    public HttpEasyDefaults trustAllHosts(boolean trustAllHosts) {
        HttpEasyDefaults.trustAllHosts = trustAllHosts;
        return this;
    }

    public HttpEasyDefaults authorization(String username, String password) {
        authUser = username;
        authPassword = password;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HttpEasyDefaults proxyConfiguration(ProxyConfiguration configuration) {
        proxyConfiguration = configuration;
        if (configuration != ProxyConfiguration.AUTOMATIC || proxySearch != null) return this;
        Class<HttpEasyDefaults> clazz = HttpEasyDefaults.class;
        synchronized (HttpEasyDefaults.class) {
            if (proxySearch != null) return this;
            Logger.setBackend((Logger.LogBackEnd)ProxyVoleLoggerFactory.getBackendLogger());
            proxySearch = ProxySearch.getDefaultProxySearch().getProxySelector();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this;
        }
    }

    public HttpEasyDefaults proxy(Proxy proxy) {
        HttpEasyDefaults.proxy = proxy;
        return this;
    }

    public HttpEasyDefaults proxyAuth(String userName, String password) {
        proxyUser = userName;
        proxyPassword = password;
        return this;
    }

    public HttpEasyDefaults bypassProxy(boolean bypassProxy) {
        HttpEasyDefaults.bypassProxy = bypassProxy;
        return this;
    }

    public HttpEasyDefaults nonProxyHosts(String proxyBypassHosts) {
        nonProxyHosts = HttpEasyDefaults.splitHosts(proxyBypassHosts);
        return this;
    }

    private static List<String> splitHosts(String hosts) {
        return Arrays.asList(Arrays.stream(hosts.split(",")).map(String::trim).map(String::toLowerCase).toArray(String[]::new));
    }

    public HttpEasyDefaults baseUrl(String baseUrl) {
        HttpEasyDefaults.baseUrl = baseUrl;
        return this;
    }

    public HttpEasyDefaults sensitiveParameters(String ... params) {
        sensitiveParameters.addAll(Arrays.asList(params));
        return this;
    }

    public HttpEasyDefaults withLogWriter(LogWriter logWriter) {
        defaultLogWriter = logWriter;
        return this;
    }

    public HttpEasyDefaults logRequest(boolean logRequest) {
        HttpEasyDefaults.logRequest = logRequest;
        return this;
    }

    public HttpEasyDefaults logRequestDetails() {
        logRequestDetails = true;
        return this;
    }

    public HttpEasyDefaults logRequestDetails(boolean logRequestDetails) {
        HttpEasyDefaults.logRequestDetails = logRequestDetails;
        return this;
    }

    public static boolean isTrustAllCertificates() {
        return trustAllCertificates;
    }

    public static boolean isTrustAllHosts() {
        return trustAllHosts;
    }

    public static List<String> getSensitiveParameters() {
        return sensitiveParameters;
    }

    public static String getAuthUser() {
        return authUser;
    }

    public static String getAuthPassword() {
        return authPassword;
    }

    public static Proxy getProxy(URL url) {
        List<Proxy> proxies;
        if (proxyConfiguration == ProxyConfiguration.MANUAL) {
            if (bypassProxy && HttpEasyDefaults.isProxyBypassHost(url)) {
                return Proxy.NO_PROXY;
            }
            return proxy;
        }
        Proxy proxy = Proxy.NO_PROXY;
        if (proxySearch != null && (proxies = proxySearch.select(HttpEasyDefaults.getUri(url))) != null) {
            block4: for (Proxy p : proxies) {
                switch (p.type()) {
                    case HTTP: {
                        proxy = p;
                        break block4;
                    }
                    case DIRECT: {
                        proxy = p;
                    }
                    default: {
                        continue block4;
                    }
                }
            }
        }
        return proxy;
    }

    private static boolean isProxyBypassHost(URL url) {
        String host = url.getHost().toLowerCase();
        return nonProxyHosts.stream().anyMatch(pattern -> host.matches(HttpEasyDefaults.escapePattern(pattern)));
    }

    private static String escapePattern(String pattern) {
        return pattern.replace(".", "\\.").replace("*", ".*");
    }

    public static String getProxyUser() {
        return proxyUser;
    }

    public static String getProxyPassword() {
        return proxyPassword;
    }

    public static String getBaseUrl() {
        return baseUrl;
    }

    public static LogWriter getDefaultLogWriter() {
        return defaultLogWriter;
    }

    public static boolean getLogRequest() {
        return logRequest;
    }

    public static boolean getLogRequestDetails() {
        return logRequestDetails;
    }

    private static URI getUri(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

