/*
 * SonarQube, open source software quality management tool.
 * Copyright (C) 2008-2014 SonarSource
 * mailto:contact AT sonarsource DOT com
 *
 * SonarQube is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * SonarQube is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.sonar.batch.scan.filesystem;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;

import java.util.Map;

class StatusDetection {

  private final Map<String, String> previousHashByRelativePath;

  StatusDetection(Map<String, String> previousHashByRelativePath) {
    this.previousHashByRelativePath = previousHashByRelativePath;
  }

  InputFile.Status status(String relativePath, String hash) {
    String previousHash = previousHashByRelativePath.get(relativePath);

    if (StringUtils.equals(hash, previousHash)) {
      return InputFile.Status.SAME;
    }
    if (StringUtils.isEmpty(previousHash)) {
      return InputFile.Status.ADDED;
    }
    return InputFile.Status.CHANGED;
  }
}
