/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.maven;

import com.google.common.base.Strings;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

public class MavenPhaseExecutor
implements BatchComponent {
    public static final String PROP_PHASE = "sonar.phase";
    private final MavenPluginExecutor executor;
    private final DefaultModuleFileSystem fs;
    private final Settings settings;
    private final DatabaseSession session;

    public MavenPhaseExecutor(DefaultModuleFileSystem fs, MavenPluginExecutor executor, Settings settings, DatabaseSession session) {
        this.fs = fs;
        this.executor = executor;
        this.settings = settings;
        this.session = session;
    }

    public void execute(Project project) {
        this.session.commitAndClose();
        String mavenPhase = this.settings.getString(PROP_PHASE);
        if (!Strings.isNullOrEmpty((String)mavenPhase)) {
            this.executor.execute(project, this.fs, mavenPhase);
        }
    }
}

