/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.maven.project.MavenProject;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.api.resources.Java;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;

public class ProjectFileSystemAdapter
implements ProjectFileSystem {
    private final DefaultModuleFileSystem target;
    private final PathResolver pathResolver = new PathResolver();
    private final MavenProject pom;

    public ProjectFileSystemAdapter(DefaultModuleFileSystem target, Project project, @Nullable MavenProject pom) {
        this.target = target;
        this.pom = pom;
        project.setFileSystem((ProjectFileSystem)this);
    }

    public ProjectFileSystemAdapter(DefaultModuleFileSystem target, Project project) {
        this(target, project, null);
    }

    public void start() {
    }

    public Charset getSourceCharset() {
        return this.target.sourceCharset();
    }

    public File getBasedir() {
        return this.target.baseDir();
    }

    public File getBuildDir() {
        File dir = this.target.buildDir();
        if (dir == null) {
            dir = new File(this.getSonarWorkingDirectory(), "build");
        }
        return dir;
    }

    public File getBuildOutputDir() {
        File dir = (File)Iterables.getFirst(this.target.binaryDirs(), null);
        if (dir == null) {
            dir = new File(this.getBuildDir(), "classes");
        }
        return dir;
    }

    public List<File> getSourceDirs() {
        return this.target.sourceDirs();
    }

    public ProjectFileSystem addSourceDir(File dir) {
        this.target.addSourceDir(dir);
        return this;
    }

    public List<File> getTestDirs() {
        return this.target.testDirs();
    }

    public ProjectFileSystem addTestDir(File dir) {
        this.target.addTestDir(dir);
        return this;
    }

    public File getReportOutputDir() {
        if (this.pom != null) {
            return this.resolvePath(this.pom.getReporting().getOutputDirectory());
        }
        return new File(this.getBuildDir(), "site");
    }

    public File getSonarWorkingDirectory() {
        return this.target.workingDir();
    }

    public File resolvePath(String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            try {
                file = new File(this.getBasedir(), path).getCanonicalFile();
            }
            catch (IOException e) {
                throw new SonarException("Unable to resolve path '" + path + "'", (Throwable)e);
            }
        }
        return file;
    }

    public List<File> getSourceFiles(Language ... langs) {
        ArrayList result = Lists.newArrayList();
        for (Language lang : langs) {
            result.addAll(this.target.files(FileQuery.onSource().onLanguage(new String[]{lang.getKey()})));
        }
        return result;
    }

    public List<File> getJavaSourceFiles() {
        return this.getSourceFiles(new Language[]{Java.INSTANCE});
    }

    public boolean hasJavaSourceFiles() {
        return !this.getJavaSourceFiles().isEmpty();
    }

    public List<File> getTestFiles(Language ... langs) {
        ArrayList result = Lists.newArrayList();
        for (Language lang : langs) {
            result.addAll(this.target.files(FileQuery.onTest().onLanguage(new String[]{lang.getKey()})));
        }
        return result;
    }

    public boolean hasTestFiles(Language lang) {
        return !this.getTestFiles(lang).isEmpty();
    }

    public File writeToWorkingDirectory(String content, String fileName) throws IOException {
        File file = new File(this.target.workingDir(), fileName);
        FileUtils.writeStringToFile((File)file, (String)content, (String)"UTF-8");
        return file;
    }

    public File getFileFromBuildDirectory(String filename) {
        File file = new File(this.getBuildDir(), filename);
        return file.exists() ? file : null;
    }

    public Resource toResource(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        PathResolver.RelativePath relativePath = this.pathResolver.relativePath(this.getSourceDirs(), file);
        if (relativePath == null) {
            return null;
        }
        return file.isFile() ? new org.sonar.api.resources.File(relativePath.path()) : new Directory(relativePath.path());
    }

    public List<org.sonar.api.resources.InputFile> mainFiles(String ... langs) {
        ArrayList result = Lists.newArrayList();
        Iterable<InputFile> files = this.target.inputFiles(FileQuery.onSource().onLanguage(langs));
        for (InputFile file : files) {
            String sourceDir = file.attribute("SRC_DIR_PATH");
            String sourceRelativePath = file.attribute("SRC_REL_PATH");
            if (sourceDir == null || sourceRelativePath == null) continue;
            result.add(InputFileUtils.create((File)new File(sourceDir), (String)sourceRelativePath));
        }
        return result;
    }

    public List<org.sonar.api.resources.InputFile> testFiles(String ... langs) {
        ArrayList result = Lists.newArrayList();
        Iterable<InputFile> files = this.target.inputFiles(FileQuery.onTest().onLanguage(langs));
        for (InputFile file : files) {
            String sourceDir = file.attribute("SRC_DIR_PATH");
            String sourceRelativePath = file.attribute("SRC_REL_PATH");
            if (sourceDir == null || sourceRelativePath == null) continue;
            result.add(InputFileUtils.create((File)new File(sourceDir), (String)sourceRelativePath));
        }
        return result;
    }
}

