/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.io.File;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;

public class LanguageRecognizer
implements BatchComponent,
Startable {
    private final Project project;
    private final Language[] languages;
    private SetMultimap<String, String> langsByExtension = HashMultimap.create();
    private boolean ignoreFileExtension = false;

    public LanguageRecognizer(Project project, Language[] languages) {
        this.project = project;
        this.languages = languages;
    }

    public LanguageRecognizer(Project project) {
        this(project, new Language[0]);
    }

    public void start() {
        for (Language language : this.languages) {
            if (language.getFileSuffixes().length == 0 && language.getKey().equals(this.project.getLanguageKey())) {
                this.ignoreFileExtension = true;
                continue;
            }
            for (String suffix : language.getFileSuffixes()) {
                String extension = LanguageRecognizer.sanitizeExtension(suffix);
                this.langsByExtension.put((Object)extension, (Object)language.getKey());
            }
        }
        for (String extension : this.langsByExtension.keySet()) {
            Set langs = this.langsByExtension.get((Object)extension);
            if (langs.size() <= 1) continue;
            this.warnConflict(extension, langs);
        }
    }

    @VisibleForTesting
    void warnConflict(String extension, Set<String> langs) {
        LoggerFactory.getLogger(LanguageRecognizer.class).warn(String.format("File extension '%s' is declared by several plugins: %s", extension, StringUtils.join(langs, (String)", ")));
    }

    public void stop() {
    }

    @CheckForNull
    String of(File file) {
        if (this.ignoreFileExtension) {
            return this.project.getLanguageKey();
        }
        String extension = LanguageRecognizer.sanitizeExtension(FilenameUtils.getExtension((String)file.getName()));
        Set langs = this.langsByExtension.get((Object)extension);
        return langs.contains(this.project.getLanguageKey()) ? this.project.getLanguageKey() : null;
    }

    static String sanitizeExtension(String suffix) {
        return StringUtils.lowerCase((String)StringUtils.removeStart((String)suffix, (String)"."));
    }
}

