/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

class FileHashDigest {
    static final FileHashDigest INSTANCE = new FileHashDigest();

    private FileHashDigest() {
    }

    String hash(File file, Charset charset) {
        String string;
        BufferedReader reader = null;
        try {
            MessageDigest md5Digest = DigestUtils.getMd5Digest();
            md5Digest.reset();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));
            int i = ((Reader)reader).read();
            boolean afterCR = true;
            while (i != -1) {
                char c = (char)i;
                if (afterCR) {
                    afterCR = false;
                    if (c == '\n') {
                        i = ((Reader)reader).read();
                        continue;
                    }
                }
                if (c == '\r') {
                    afterCR = true;
                    c = '\n';
                }
                md5Digest.update(this.charToBytesUTF(c));
                i = ((Reader)reader).read();
            }
            string = Hex.encodeHexString((byte[])md5Digest.digest());
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Fail to compute hash of file %s with charset %s", file.getAbsolutePath(), charset), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return string;
    }

    private byte[] charToBytesUTF(char c) {
        char[] buffer = new char[]{c};
        byte[] b = new byte[buffer.length << 1];
        for (int i = 0; i < buffer.length; ++i) {
            int bpos = i << 1;
            b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(buffer[i] & 0xFF);
        }
        return b;
    }
}

