/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.File;
import org.sonar.api.scan.filesystem.FileSystemFilter;
import org.sonar.api.scan.filesystem.FileType;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.scan.filesystem.internal.InputFileFilter;

public class DeprecatedFileFilters
implements InputFileFilter {
    private final FileSystemFilter[] filters;

    public DeprecatedFileFilters(FileSystemFilter[] filters) {
        this.filters = filters;
    }

    public DeprecatedFileFilters() {
        this(new FileSystemFilter[0]);
    }

    public boolean accept(InputFile inputFile) {
        if (this.filters.length > 0) {
            DeprecatedContext context = new DeprecatedContext(inputFile);
            for (FileSystemFilter filter : this.filters) {
                if (filter.accept(inputFile.file(), (FileSystemFilter.Context)context)) continue;
                return false;
            }
        }
        return true;
    }

    class DeprecatedContext
    implements FileSystemFilter.Context {
        private final InputFile inputFile;

        DeprecatedContext(InputFile inputFile) {
            this.inputFile = inputFile;
        }

        public ModuleFileSystem fileSystem() {
            throw new UnsupportedOperationException("Not supported since 4.0");
        }

        public FileType type() {
            String type = this.inputFile.attribute("TYPE");
            return type == null ? null : FileType.valueOf((String)type.toUpperCase());
        }

        public File relativeDir() {
            String path = this.inputFile.attribute("SRC_DIR_PATH");
            return path != null ? new File(path) : null;
        }

        public String relativePath() {
            return this.inputFile.attribute("SRC_REL_PATH");
        }

        public String canonicalPath() {
            return this.inputFile.absolutePath();
        }
    }
}

