/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.picocontainer.Startable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.scan.filesystem.internal.InputFiles;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.scan.filesystem.FileIndex;
import org.sonar.batch.scan.filesystem.FileQueryFilter;
import org.sonar.batch.scan.filesystem.ModuleFileSystemInitializer;

public class DefaultModuleFileSystem
implements ModuleFileSystem,
Startable {
    private final String moduleKey;
    private final FileIndex index;
    private final Settings settings;
    private File baseDir;
    private File workingDir;
    private File buildDir;
    private List<File> sourceDirs = Lists.newArrayList();
    private List<File> testDirs = Lists.newArrayList();
    private List<File> binaryDirs = Lists.newArrayList();
    private List<File> sourceFiles = Lists.newArrayList();
    private List<File> testFiles = Lists.newArrayList();
    private AnalysisMode analysisMode;
    private boolean dirsChanged = false;

    public DefaultModuleFileSystem(ProjectDefinition module, Settings settings, FileIndex index, ModuleFileSystemInitializer initializer, AnalysisMode analysisMode) {
        this(module.getKey(), settings, index, initializer, analysisMode);
    }

    @VisibleForTesting
    DefaultModuleFileSystem(String moduleKey, Settings settings, FileIndex index, ModuleFileSystemInitializer initializer, AnalysisMode analysisMode) {
        this.moduleKey = moduleKey;
        this.settings = settings;
        this.index = index;
        this.analysisMode = analysisMode;
        this.baseDir = initializer.baseDir();
        this.workingDir = initializer.workingDir();
        this.buildDir = initializer.buildDir();
        this.sourceDirs = initializer.sourceDirs();
        this.testDirs = initializer.testDirs();
        this.binaryDirs = initializer.binaryDirs();
        this.sourceFiles = initializer.additionalSourceFiles();
        this.testFiles = initializer.additionalTestFiles();
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    public File baseDir() {
        return this.baseDir;
    }

    @CheckForNull
    public File buildDir() {
        return this.buildDir;
    }

    public List<File> sourceDirs() {
        return this.sourceDirs;
    }

    public List<File> testDirs() {
        return this.testDirs;
    }

    public List<File> binaryDirs() {
        return this.binaryDirs;
    }

    public File workingDir() {
        return this.workingDir;
    }

    List<File> sourceFiles() {
        return this.sourceFiles;
    }

    List<File> testFiles() {
        return this.testFiles;
    }

    @Deprecated
    void addSourceDir(File dir) {
        this.sourceDirs.add(dir);
        this.dirsChanged = true;
    }

    @Deprecated
    void addTestDir(File dir) {
        this.testDirs.add(dir);
        this.dirsChanged = true;
    }

    public Charset sourceCharset() {
        String encoding = this.settings.getString("sonar.sourceEncoding");
        Charset charset = StringUtils.isNotEmpty((String)encoding) ? Charset.forName(StringUtils.trim((String)encoding)) : Charset.defaultCharset();
        return charset;
    }

    boolean isDefaultSourceCharset() {
        return !this.settings.hasKey("sonar.sourceEncoding");
    }

    public Iterable<InputFile> inputFiles(FileQuery query) {
        if (this.dirsChanged) {
            this.index();
            this.dirsChanged = false;
        }
        ArrayList result = Lists.newArrayList();
        FileQueryFilter filter = new FileQueryFilter(this.analysisMode, query);
        for (InputFile input : this.index.inputFiles(this.moduleKey)) {
            if (!filter.accept(input)) continue;
            result.add(input);
        }
        return result;
    }

    public List<File> files(FileQuery query) {
        return InputFiles.toFiles(this.inputFiles(query));
    }

    public void start() {
        this.index();
    }

    public void stop() {
    }

    public void resetDirs(File basedir, File buildDir, List<File> sourceDirs, List<File> testDirs, List<File> binaryDirs) {
        Preconditions.checkNotNull((Object)basedir, (Object)"Basedir can't be null");
        this.baseDir = basedir;
        this.buildDir = buildDir;
        this.sourceDirs = this.existingDirs(sourceDirs);
        this.testDirs = this.existingDirs(testDirs);
        this.binaryDirs = this.existingDirs(binaryDirs);
        this.index();
    }

    public void index() {
        this.index.index(this);
    }

    private List<File> existingDirs(List<File> dirs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File dir : dirs) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            builder.add((Object)dir);
        }
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleFileSystem that = (DefaultModuleFileSystem)o;
        return this.moduleKey.equals(that.moduleKey);
    }

    public int hashCode() {
        return this.moduleKey.hashCode();
    }
}

