/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.scan.filesystem.internal.InputFileFilter;

class AttributeFilter
implements InputFileFilter {
    private final String key;
    private final Collection<String> values;

    AttributeFilter(String key, Collection<String> values) {
        this.key = key;
        this.values = values;
    }

    public boolean accept(InputFile inputFile) {
        String value = inputFile.attribute(this.key);
        return this.values.contains(value);
    }

    @VisibleForTesting
    String key() {
        return this.key;
    }

    @VisibleForTesting
    Collection<String> values() {
        return this.values;
    }
}

