/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.SonarException;
import org.sonar.core.component.ComponentKeys;
import org.sonar.core.resource.ResourceDao;

public class ProjectReactorValidator {
    private final Settings settings;
    private final ResourceDao resourceDao;

    public ProjectReactorValidator(Settings settings, ResourceDao resourceDao) {
        this.settings = settings;
        this.resourceDao = resourceDao;
    }

    public void validate(ProjectReactor reactor) {
        String projectKey;
        if (this.settings.getBoolean("sonar.preventAutoProjectCreation") && this.resourceDao.findByKey(projectKey = reactor.getRoot().getKey()) == null) {
            throw new SonarException("Unable to scan non-existing project " + projectKey);
        }
        ArrayList<String> validationMessages = new ArrayList<String>();
        for (ProjectDefinition moduleDef : reactor.getProjects()) {
            this.validateModule(moduleDef, validationMessages);
        }
        this.validateBranch(validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new SonarException("Validation of project reactor failed:\n  o " + Joiner.on((String)"\n  o ").join(validationMessages));
        }
    }

    private void validateModule(ProjectDefinition moduleDef, List<String> validationMessages) {
        this.validateKey(moduleDef, validationMessages);
    }

    private void validateKey(ProjectDefinition def, List<String> validationMessages) {
        if (!ComponentKeys.isValidModuleKey((String)def.getKey())) {
            validationMessages.add(String.format("%s is not a valid project or module key", def.getKey()));
        }
    }

    private void validateBranch(List<String> validationMessages) {
        String branch = this.settings.getString("sonar.branch");
        if (StringUtils.isNotEmpty((String)branch) && !ComponentKeys.isValidModuleKey((String)branch)) {
            validationMessages.add(String.format("%s is not a valid branch name", branch));
        }
    }
}

