/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.phases.SensorExecutionEvent;
import org.sonar.batch.phases.SensorMatcher;
import org.sonar.batch.phases.SensorsPhaseEvent;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.maven.MavenPluginExecutor;

public class SensorsExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SensorsExecutor.class);
    private MavenPluginExecutor mavenExecutor;
    private EventBus eventBus;
    private Project project;
    private DefaultModuleFileSystem fs;
    private BatchExtensionDictionnary selector;
    private final DatabaseSession session;
    private final SensorMatcher sensorMatcher;

    public SensorsExecutor(BatchExtensionDictionnary selector, Project project, DefaultModuleFileSystem fs, MavenPluginExecutor mavenExecutor, EventBus eventBus, DatabaseSession session, SensorMatcher sensorMatcher) {
        this.selector = selector;
        this.mavenExecutor = mavenExecutor;
        this.eventBus = eventBus;
        this.project = project;
        this.fs = fs;
        this.session = session;
        this.sensorMatcher = sensorMatcher;
    }

    public void execute(SensorContext context) {
        Collection<Sensor> sensors = this.selector.select(Sensor.class, this.project, true, this.sensorMatcher);
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(sensors), true));
        for (Sensor sensor : sensors) {
            this.session.commitAndClose();
            this.eventBus.fireEvent(new SensorExecutionEvent(sensor, true));
            this.executeMavenPlugin(sensor);
            sensor.analyse(this.project, context);
            this.eventBus.fireEvent(new SensorExecutionEvent(sensor, false));
        }
        this.eventBus.fireEvent(new SensorsPhaseEvent(Lists.newArrayList(sensors), false));
    }

    private void executeMavenPlugin(Sensor sensor) {
        MavenPluginHandler handler;
        if (sensor instanceof DependsUponMavenPlugin && (handler = ((DependsUponMavenPlugin)sensor).getMavenPluginHandler(this.project)) != null) {
            TimeProfiler profiler = new TimeProfiler(LOG).start("Execute maven plugin " + handler.getArtifactId());
            this.mavenExecutor.execute(this.project, this.fs, handler);
            profiler.stop();
        }
    }
}

