/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.batch.IssueFilter;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.rules.Violation;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.issue.DefaultIssueFilterChain;
import org.sonar.batch.issue.DeprecatedViolations;

public class IssueFilters
implements BatchExtension {
    private final ViolationFilters deprecatedFilters;
    private final DeprecatedViolations deprecatedViolations;
    private final org.sonar.api.issue.IssueFilter[] exclusionFilters;
    private final IssueFilter[] filters;

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations, org.sonar.api.issue.IssueFilter[] exclusionFilters, IssueFilter[] filters) {
        this.deprecatedFilters = deprecatedFilters;
        this.deprecatedViolations = deprecatedViolations;
        this.exclusionFilters = exclusionFilters;
        this.filters = filters;
    }

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations, IssueFilter[] filters) {
        this(deprecatedFilters, deprecatedViolations, new org.sonar.api.issue.IssueFilter[0], filters);
    }

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations, org.sonar.api.issue.IssueFilter[] exclusionFilters) {
        this(deprecatedFilters, deprecatedViolations, exclusionFilters, new IssueFilter[0]);
    }

    public IssueFilters(ViolationFilters deprecatedFilters, DeprecatedViolations deprecatedViolations) {
        this(deprecatedFilters, deprecatedViolations, new org.sonar.api.issue.IssueFilter[0]);
    }

    public boolean accept(DefaultIssue issue, @Nullable Violation violation) {
        if (new DefaultIssueFilterChain(this.filters).accept((Issue)issue)) {
            for (org.sonar.api.issue.IssueFilter filter : this.exclusionFilters) {
                if (filter.accept((Issue)issue)) continue;
                return false;
            }
            if (!this.deprecatedFilters.isEmpty()) {
                Violation v = violation != null ? violation : this.deprecatedViolations.toViolation(issue);
                return !this.deprecatedFilters.isIgnored(v);
            }
            return true;
        }
        return false;
    }
}

