/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import org.sonar.api.BatchComponent;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;

public class IssueCache
implements BatchComponent {
    private final Cache<String, DefaultIssue> cache;

    public IssueCache(Caches caches) {
        this.cache = caches.createCache("issues");
    }

    public Iterable<DefaultIssue> byComponent(String componentKey) {
        return this.cache.values(componentKey);
    }

    public Iterable<DefaultIssue> all() {
        return this.cache.allValues();
    }

    public IssueCache put(DefaultIssue issue) {
        this.cache.put(issue.componentKey(), issue.key(), issue);
        return this;
    }

    public boolean remove(Issue issue) {
        return this.cache.remove(issue.componentKey(), issue.key());
    }
}

