/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import java.util.Date;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.components.PastSnapshot;

public class PastSnapshotFinderByVersion
implements BatchExtension {
    private final DatabaseSession session;

    public PastSnapshotFinderByVersion(DatabaseSession session) {
        this.session = session;
    }

    PastSnapshot findByVersion(Snapshot projectSnapshot, String version) {
        PastSnapshot result;
        String hql = "from " + Snapshot.class.getSimpleName() + " where version=:version AND resourceId=:resourceId AND status=:status AND qualifier<>:lib order by createdAt desc";
        List snapshots = this.session.createQuery(hql).setParameter("version", (Object)version).setParameter("resourceId", (Object)projectSnapshot.getResourceId()).setParameter("status", (Object)"P").setParameter("lib", (Object)"LIB").setMaxResults(1).getResultList();
        if (snapshots.isEmpty()) {
            result = new PastSnapshot("version");
        } else {
            Snapshot snapshot = (Snapshot)snapshots.get(0);
            Date targetDate = snapshot.getCreatedAt();
            result = new PastSnapshot("version", targetDate, snapshot).setModeParameter(version);
        }
        return result;
    }
}

