/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.bootstrap.ServerClient;
import org.sonar.core.plugins.RemotePlugin;
import org.sonar.core.plugins.RemotePluginFile;
import org.sonar.home.cache.FileCache;

public class PluginDownloader
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDownloader.class);
    private ServerClient server;
    private FileCache fileCache;

    public PluginDownloader(FileCache fileCache, ServerClient server) {
        this.server = server;
        this.fileCache = fileCache;
    }

    public List<File> downloadPlugin(final RemotePlugin remote) {
        try {
            ArrayList files = Lists.newArrayList();
            for (final RemotePluginFile file : remote.getFiles()) {
                File cachedFile = this.fileCache.get(file.getFilename(), file.getHash(), new FileCache.Downloader(){

                    public void download(String filename, File toFile) throws IOException {
                        String url = "/deploy/plugins/" + remote.getKey() + "/" + file.getFilename();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Download {} to {}", (Object)url, (Object)toFile.getAbsolutePath());
                        } else {
                            LOG.info("Download {}", (Object)file.getFilename());
                        }
                        PluginDownloader.this.server.download(url, toFile);
                    }
                });
                files.add(cachedFile);
            }
            return files;
        }
        catch (Exception e) {
            throw new SonarException("Fail to download plugin: " + remote.getKey(), (Throwable)e);
        }
    }

    public List<RemotePlugin> downloadPluginIndex() {
        String url = "/deploy/plugins/index.txt";
        try {
            LOG.debug("Download index of plugins");
            String indexContent = this.server.request(url);
            String[] rows = StringUtils.split((String)indexContent, (char)'\n');
            ArrayList remoteLocations = Lists.newArrayList();
            for (String row : rows) {
                remoteLocations.add(RemotePlugin.unmarshal((String)row));
            }
            return remoteLocations;
        }
        catch (Exception e) {
            throw new SonarException("Fail to download plugins index: " + url, (Throwable)e);
        }
    }
}

