/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.Plugin;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.PluginMetadata;
import org.sonar.api.platform.PluginRepository;
import org.sonar.api.utils.TempFolder;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.PluginDownloader;
import org.sonar.core.plugins.DefaultPluginMetadata;
import org.sonar.core.plugins.PluginClassloaders;
import org.sonar.core.plugins.PluginInstaller;
import org.sonar.core.plugins.RemotePlugin;

public class BatchPluginRepository
implements PluginRepository {
    private static final Logger LOG = LoggerFactory.getLogger(BatchPluginRepository.class);
    private static final String CORE_PLUGIN = "core";
    private static final String ENGLISH_PACK_PLUGIN = "l10nen";
    private PluginDownloader pluginDownloader;
    private Map<String, Plugin> pluginsByKey;
    private Map<String, PluginMetadata> metadataByKey;
    private Settings settings;
    private PluginClassloaders classLoaders;
    private TempFolder tempDirectories;
    private final AnalysisMode analysisMode;

    public BatchPluginRepository(PluginDownloader pluginDownloader, TempFolder tempDirectories, Settings settings, AnalysisMode analysisMode) {
        this.pluginDownloader = pluginDownloader;
        this.tempDirectories = tempDirectories;
        this.settings = settings;
        this.analysisMode = analysisMode;
    }

    public void start() {
        LOG.info("Install plugins");
        this.doStart(this.pluginDownloader.downloadPluginIndex());
    }

    void doStart(List<RemotePlugin> remotePlugins) {
        PluginFilter filter = new PluginFilter(this.settings, this.analysisMode);
        PluginInstaller extractor = new PluginInstaller();
        this.metadataByKey = Maps.newHashMap();
        for (RemotePlugin remote : remotePlugins) {
            if (!filter.accepts(remote.getKey())) continue;
            List<File> pluginFiles = this.pluginDownloader.downloadPlugin(remote);
            List<File> extensionFiles = pluginFiles.subList(1, pluginFiles.size());
            File targetDir = this.tempDirectories.newDir("plugins/" + remote.getKey());
            LOG.debug("Installing plugin {} into {}", (Object)remote.getKey(), (Object)targetDir.getAbsolutePath());
            DefaultPluginMetadata metadata = extractor.install(pluginFiles.get(0), remote.isCore(), extensionFiles, targetDir);
            if (StringUtils.isBlank((String)metadata.getBasePlugin()) || filter.accepts(metadata.getBasePlugin())) {
                this.metadataByKey.put(metadata.getKey(), (PluginMetadata)metadata);
                continue;
            }
            LOG.debug("Excluded plugin: " + metadata.getKey());
        }
        this.classLoaders = new PluginClassloaders(Thread.currentThread().getContextClassLoader());
        this.pluginsByKey = this.classLoaders.init(this.metadataByKey.values());
    }

    public void stop() {
        if (this.classLoaders != null) {
            this.classLoaders.clean();
            this.classLoaders = null;
        }
    }

    public Plugin getPlugin(String key) {
        return this.pluginsByKey.get(key);
    }

    public Collection<PluginMetadata> getMetadata() {
        return this.metadataByKey.values();
    }

    public PluginMetadata getMetadata(String pluginKey) {
        return this.metadataByKey.get(pluginKey);
    }

    public Map<PluginMetadata, Plugin> getPluginsByMetadata() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, PluginMetadata> entry : this.metadataByKey.entrySet()) {
            String pluginKey = entry.getKey();
            PluginMetadata metadata = entry.getValue();
            result.put(metadata, this.pluginsByKey.get(pluginKey));
        }
        return result;
    }

    static class PluginFilter {
        private static final String PROPERTY_IS_DEPRECATED_MSG = "Property {0} is deprecated. Please use {1} instead.";
        Set<String> whites = Sets.newHashSet();
        Set<String> blacks = Sets.newHashSet();

        PluginFilter(Settings settings, AnalysisMode mode) {
            if (settings.hasKey("sonar.includePlugins")) {
                this.whites.addAll(Arrays.asList(settings.getStringArray("sonar.includePlugins")));
            }
            if (settings.hasKey("sonar.excludePlugins")) {
                this.blacks.addAll(Arrays.asList(settings.getStringArray("sonar.excludePlugins")));
            }
            if (mode.isPreview()) {
                if (settings.hasKey("sonar.dryRun.includePlugins")) {
                    LOG.warn(MessageFormat.format(PROPERTY_IS_DEPRECATED_MSG, "sonar.dryRun.includePlugins", "sonar.preview.includePlugins"));
                    this.whites.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.includePlugins", ""));
                } else {
                    this.whites.addAll(PluginFilter.propertyValues(settings, "sonar.preview.includePlugins", ""));
                }
                if (settings.hasKey("sonar.dryRun.excludePlugins")) {
                    LOG.warn(MessageFormat.format(PROPERTY_IS_DEPRECATED_MSG, "sonar.dryRun.excludePlugins", "sonar.preview.excludePlugins"));
                    this.blacks.addAll(PluginFilter.propertyValues(settings, "sonar.dryRun.excludePlugins", "devcockpit,pdfreport,report,scmactivity,views,jira"));
                } else {
                    this.blacks.addAll(PluginFilter.propertyValues(settings, "sonar.preview.excludePlugins", "devcockpit,pdfreport,report,scmactivity,views,jira"));
                }
            }
            if (!this.whites.isEmpty()) {
                LOG.info("Include plugins: " + Joiner.on((String)", ").join(this.whites));
            }
            if (!this.blacks.isEmpty()) {
                LOG.info("Exclude plugins: " + Joiner.on((String)", ").join(this.blacks));
            }
        }

        static List<String> propertyValues(Settings settings, String key, String defaultValue) {
            String s = StringUtils.defaultIfEmpty((String)settings.getString(key), (String)defaultValue);
            return Arrays.asList(StringUtils.split((String)s, (String)","));
        }

        boolean accepts(String pluginKey) {
            if (BatchPluginRepository.CORE_PLUGIN.equals(pluginKey) || BatchPluginRepository.ENGLISH_PACK_PLUGIN.equals(pluginKey)) {
                return true;
            }
            if (!this.whites.isEmpty()) {
                return this.whites.contains(pluginKey);
            }
            return this.blacks.isEmpty() || !this.blacks.contains(pluginKey);
        }
    }
}

