/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.CheckProject;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Project;
import org.sonar.batch.bootstrap.ExtensionMatcher;

public class BatchExtensionDictionnary
extends org.sonar.api.batch.BatchExtensionDictionnary {
    public BatchExtensionDictionnary(ComponentContainer componentContainer) {
        super(componentContainer);
    }

    public <T> Collection<T> select(Class<T> type, Project project, boolean sort, ExtensionMatcher matcher) {
        List<T> result = this.getFilteredExtensions(type, project, matcher);
        if (sort) {
            return this.sort(result);
        }
        return result;
    }

    private <T> List<T> getFilteredExtensions(Class<T> type, Project project, ExtensionMatcher matcher) {
        ArrayList result = Lists.newArrayList();
        for (BatchExtension extension : this.getExtensions()) {
            if (!this.shouldKeep(type, extension, project, matcher)) continue;
            result.add(extension);
        }
        return result;
    }

    private boolean shouldKeep(Class type, Object extension, Project project, ExtensionMatcher matcher) {
        boolean keep;
        boolean bl = keep = ClassUtils.isAssignable(extension.getClass(), (Class)type) && (matcher == null || matcher.accept(extension));
        if (keep && project != null && ClassUtils.isAssignable(extension.getClass(), CheckProject.class)) {
            keep = ((CheckProject)extension).shouldExecuteOnProject(project);
        }
        return keep;
    }
}

