/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.utils.KeyValueFormat;

@Beta
public class DefaultFileLinesContext
implements FileLinesContext {
    private final SonarIndex index;
    private final Resource resource;
    private final Map<String, Map<Integer, Object>> map = Maps.newHashMap();

    public DefaultFileLinesContext(SonarIndex index, Resource resource) {
        Preconditions.checkNotNull((Object)index);
        Preconditions.checkArgument((boolean)ResourceUtils.isFile((Resource)resource));
        this.index = index;
        this.resource = resource;
    }

    public void setIntValue(String metricKey, int line, int value) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        this.setValue(metricKey, line, value);
    }

    public Integer getIntValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Map lines = this.map.get(metricKey);
        if (lines == null) {
            lines = this.loadData(metricKey, (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter());
            this.map.put(metricKey, lines);
        }
        return (Integer)lines.get(line);
    }

    public void setStringValue(String metricKey, int line, String value) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)value);
        this.setValue(metricKey, line, value);
    }

    public String getStringValue(String metricKey, int line) {
        Preconditions.checkNotNull((Object)metricKey);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0);
        Map lines = this.map.get(metricKey);
        if (lines == null) {
            lines = this.loadData(metricKey, (KeyValueFormat.Converter)KeyValueFormat.newStringConverter());
            this.map.put(metricKey, lines);
        }
        return (String)lines.get(line);
    }

    private Map<Integer, Object> getOrCreateLines(String metricKey) {
        HashMap lines = this.map.get(metricKey);
        if (lines == null) {
            lines = Maps.newHashMap();
            this.map.put(metricKey, lines);
        }
        return lines;
    }

    private void setValue(String metricKey, int line, Object value) {
        this.getOrCreateLines(metricKey).put(line, value);
    }

    public void save() {
        for (Map.Entry<String, Map<Integer, Object>> entry : this.map.entrySet()) {
            String metricKey = entry.getKey();
            Map<Integer, Object> lines = entry.getValue();
            if (!this.shouldSave(lines)) continue;
            String data = KeyValueFormat.format(lines);
            Measure measure = new Measure(metricKey).setPersistenceMode(PersistenceMode.DATABASE).setData(data);
            this.index.addMeasure(this.resource, measure);
            entry.setValue((Map<Integer, Object>)ImmutableMap.copyOf(lines));
        }
    }

    private Map loadData(String metricKey, KeyValueFormat.Converter converter) {
        Measure measure = this.index.getMeasure(this.resource, new Metric(metricKey));
        if (measure == null || measure.getData() == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf((Map)KeyValueFormat.parse((String)measure.getData(), (KeyValueFormat.Converter)KeyValueFormat.newIntegerConverter(), (KeyValueFormat.Converter)converter));
    }

    private boolean shouldSave(Map<Integer, Object> lines) {
        return !(lines instanceof ImmutableMap);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("map", this.map).toString();
    }
}

