/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import java.net.URLClassLoader;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.picocontainer.ComponentAdapter;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.batch.FakeMavenPluginExecutor;
import org.sonar.batch.MavenPluginExecutor;
import org.sonar.batch.RemoteServerMetadata;
import org.sonar.batch.ServerMetadata;
import org.sonar.batch.bootstrap.ArtifactDownloader;
import org.sonar.batch.bootstrap.BatchDatabase;
import org.sonar.batch.bootstrap.BatchExtensionInstaller;
import org.sonar.batch.bootstrap.BatchModule;
import org.sonar.batch.bootstrap.BatchPluginRepository;
import org.sonar.batch.bootstrap.DatabaseBatchCompatibility;
import org.sonar.batch.bootstrap.DryRun;
import org.sonar.batch.bootstrap.JdbcDriverHolder;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.TempDirectories;
import org.sonar.batch.config.BatchDatabaseSettingsLoader;
import org.sonar.batch.config.BatchSettings;
import org.sonar.core.persistence.DaoUtils;
import org.sonar.core.persistence.DatabaseVersion;
import org.sonar.core.persistence.MyBatis;
import org.sonar.jpa.session.DatabaseSessionProvider;
import org.sonar.jpa.session.DefaultDatabaseConnector;
import org.sonar.jpa.session.ThreadLocalDatabaseSessionFactory;

public class BootstrapModule
extends Module {
    private Object[] boostrapperComponents;
    private ProjectReactor reactor;

    public BootstrapModule(ProjectReactor reactor, Object ... boostrapperComponents) {
        this.reactor = reactor;
        this.boostrapperComponents = boostrapperComponents;
    }

    protected void configure() {
        this.addCoreSingleton(this.reactor);
        this.addCoreSingleton(new PropertiesConfiguration());
        this.addCoreSingleton(BatchSettings.class);
        this.addCoreSingleton(DryRun.class);
        this.addCoreSingleton(ServerMetadata.class);
        this.addCoreSingleton(TempDirectories.class);
        this.addCoreSingleton(HttpDownloader.class);
        this.addCoreSingleton(ArtifactDownloader.class);
        this.addCoreSingleton(JdbcDriverHolder.class);
        URLClassLoader bootstrapClassLoader = this.getComponentByType(JdbcDriverHolder.class).getClassLoader();
        Thread.currentThread().setContextClassLoader(bootstrapClassLoader);
        this.addCoreSingleton(RemoteServerMetadata.class);
        this.addCoreSingleton(BatchDatabase.class);
        this.addCoreSingleton(MyBatis.class);
        this.addCoreSingleton(DatabaseVersion.class);
        this.addCoreSingleton(DatabaseBatchCompatibility.class);
        for (Class daoClass : DaoUtils.getDaoClasses()) {
            this.addCoreSingleton(daoClass);
        }
        this.addCoreSingleton(DefaultDatabaseConnector.class);
        this.addCoreSingleton(ThreadLocalDatabaseSessionFactory.class);
        this.addAdapter((ComponentAdapter<?>)new DatabaseSessionProvider());
        for (Object component : this.boostrapperComponents) {
            this.addCoreSingleton(component);
        }
        if (!this.isMavenPluginExecutorRegistered()) {
            this.addCoreSingleton(FakeMavenPluginExecutor.class);
        }
        this.addCoreSingleton(BatchPluginRepository.class);
        this.addCoreSingleton(BatchExtensionInstaller.class);
        this.addCoreSingleton(BatchDatabaseSettingsLoader.class);
    }

    boolean isMavenPluginExecutorRegistered() {
        if (this.boostrapperComponents != null) {
            for (Object component : this.boostrapperComponents) {
                if (!(component instanceof Class) || !MavenPluginExecutor.class.isAssignableFrom((Class)component)) continue;
                return true;
            }
        }
        return false;
    }

    protected void doStart() {
        boolean dryRun = this.getComponentByType(DryRun.class).isEnabled();
        Module batchComponents = this.installChild(new BatchModule(dryRun));
        batchComponents.start();
    }
}

