/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-reactor", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseReactorMojo
extends AbstractVersionsDependencyUpdaterMojo {
    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.isProcessingParent() && this.getProject().hasParent()) {
                this.useReactor(pom, this.getProject().getParent());
            }
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useReactor(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
                this.useReactor(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useReactor(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        block0: for (Dependency dep : dependencies) {
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            for (Object reactorProject : this.reactorProjects) {
                MavenProject project = (MavenProject)reactorProject;
                if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)dep.getGroupId()) || !StringUtils.equals((CharSequence)project.getArtifactId(), (CharSequence)dep.getArtifactId()) || StringUtils.equals((CharSequence)project.getVersion(), (CharSequence)dep.getVersion())) continue;
                if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), project.getVersion(), this.getProject().getModel())) continue block0;
                this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + project.getVersion()));
                continue block0;
            }
        }
    }

    private void useReactor(ModifiedPomXMLEventReader pom, MavenProject parent) throws XMLStreamException, ArtifactMetadataRetrievalException {
        for (Object reactorProject : this.reactorProjects) {
            MavenProject project = (MavenProject)reactorProject;
            if (!StringUtils.equals((CharSequence)project.getGroupId(), (CharSequence)parent.getGroupId()) || !StringUtils.equals((CharSequence)project.getArtifactId(), (CharSequence)parent.getArtifactId()) || StringUtils.equals((CharSequence)project.getVersion(), (CharSequence)parent.getVersion()) || !PomHelper.setProjectParentVersion(pom, project.getVersion())) continue;
            this.getLog().info((CharSequence)("Updated parent " + this.toString(parent) + " to version " + project.getVersion()));
        }
    }
}

