/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.properties;

import org.codehaus.mojo.properties.KeyAndDefaultValue;

abstract class ExpansionBuffer {
    private final StringBuilder resolved = new StringBuilder();
    protected String unresolved;

    protected ExpansionBuffer(String unresolved) {
        this.unresolved = unresolved != null ? unresolved : "";
    }

    public boolean hasMoreLegalPlaceholders() {
        int prefixPos = this.unresolved.indexOf("${");
        int suffixPos = this.unresolved.indexOf("}", prefixPos + 2);
        return prefixPos >= 0 && suffixPos >= 0;
    }

    public abstract KeyAndDefaultValue extractPropertyKeyAndDefaultValue();

    public String toString() {
        StringBuilder sb = new StringBuilder(this.resolved);
        return sb.append(this.unresolved).toString();
    }

    public void add(String newKey, String newValue) {
        if (this.replaced(newValue)) {
            this.expandFurther(newValue);
        } else {
            this.skipUnresolvedPlaceholder(newKey);
        }
    }

    private boolean replaced(String value) {
        return value != null;
    }

    private void expandFurther(String value) {
        this.unresolved = value + this.unresolved;
    }

    private void skipUnresolvedPlaceholder(String newKey) {
        this.resolved.append("${").append(newKey).append("}");
    }

    protected void discardToAfterNextSuffix() {
        int propertySuffixPos = this.unresolved.indexOf("}");
        this.unresolved = this.unresolved.substring(propertySuffixPos + 1);
    }

    protected void advanceToNextPrefix() {
        this.resolved.append(this.beforePrefix());
    }

    protected void discardPrefix() {
        int propertyPrefixPos = this.unresolved.indexOf("${");
        this.unresolved = this.unresolved.substring(propertyPrefixPos + 2);
    }

    private String beforePrefix() {
        int propertyPrefixPos = this.unresolved.indexOf("${");
        return this.unresolved.substring(0, propertyPrefixPos);
    }

    protected abstract String beforeNextSuffix();
}

