/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="regex-property", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class RegexPropertyMojo
extends AbstractDefinePropertyMojo {
    @Parameter(required=true)
    private String name;
    @Parameter(required=true)
    private String value;
    @Parameter(required=true)
    private String regex;
    @Parameter(defaultValue="")
    private String replacement;
    @Parameter(defaultValue="true")
    private boolean failIfNoMatch;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Pattern pattern;
        try {
            pattern = Pattern.compile(this.regex);
        }
        catch (PatternSyntaxException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        Matcher matcher = pattern.matcher(this.value);
        if (matcher.find()) {
            this.value = StringUtils.isNotEmpty((String)this.replacement) ? matcher.replaceAll(this.replacement) : matcher.replaceAll("");
        } else {
            if (this.failIfNoMatch) {
                throw new MojoFailureException("No match to regex '" + this.regex + "' found in '" + this.value + "'.");
            }
            this.getLog().info((CharSequence)("No match to regex '" + this.regex + "' found in '" + this.value + "'. " + "The initial value '" + this.value + "' is left as-is..."));
        }
        this.defineProperty(this.name, this.value);
    }
}

