/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class NullnessUtil {
    private NullnessUtil() {
        throw new AssertionError((Object)"shouldn't be instantiated");
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T castNonNull(T ref) {
        assert (ref != null) : "Misuse of castNonNull: called with a null argument";
        return ref;
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[] castNonNullDeep(T[] arr) {
        return NullnessUtil.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][] castNonNullDeep(T[][] arr) {
        return (Object[][])NullnessUtil.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][] castNonNullDeep(T[][][] arr) {
        return (Object[][][])NullnessUtil.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][] castNonNullDeep(T[][][][] arr) {
        return (Object[][][][])NullnessUtil.castNonNullArray(arr);
    }

    @EnsuresNonNull(value={"#1"})
    public static <T> T[][][][][] castNonNullDeep(T[][][][][] arr) {
        return (Object[][][][][])NullnessUtil.castNonNullArray(arr);
    }

    private static <T> T[] castNonNullArray(T[] arr) {
        assert (arr != null) : "Misuse of castNonNullArray: called with a null array argument";
        for (int i = 0; i < arr.length; ++i) {
            assert (arr[i] != null) : "Misuse of castNonNull: called with a null array element";
            NullnessUtil.checkIfArray(arr[i]);
        }
        return arr;
    }

    private static void checkIfArray(Object ref) {
        assert (ref != null) : "Misuse of checkIfArray: called with a null argument";
        Class<?> comp = ref.getClass().getComponentType();
        if (comp != null && !comp.isPrimitive()) {
            NullnessUtil.castNonNullArray((Object[])ref);
        }
    }
}

