/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.parser;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.aspectj.ajdt.internal.compiler.parser.AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Argument;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Literal;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.TheOriginalJDTParserClass;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;

public class Parser
extends TheOriginalJDTParserClass {
    private static final String ASPECTJ_DECLARATION_FACTORY = "org.aspectj.ajdt.internal.compiler.parser.DeclarationFactory";
    private static IDeclarationFactory declarationFactory;
    protected int aspectIntPtr;
    protected int[] aspectIntStack;
    private static final boolean AJ_DEBUG = false;

    static {
        try {
            Parser.initTables(Parser.class);
            declarationFactory = (IDeclarationFactory)Class.forName(ASPECTJ_DECLARATION_FACTORY).newInstance();
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionInInitializerError(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Warning: AspectJ declaration factory class not found on classpath");
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initialize(boolean initializeNLS) {
        super.initialize(initializeNLS);
        this.aspectIntPtr = -1;
        this.aspectIntStack = new int[4];
    }

    @Override
    public void initializeScanner() {
        this.scanner = new Scanner(false, false, this.options.getSeverity(256) != 256, this.options.sourceLevel, this.options.taskTags, this.options.taskPriorities, this.options.isTaskCaseSensitive);
    }

    void println(Object o) {
    }

    private void printStack(Object[] s, int p) {
        List<Object> list = Arrays.asList(s);
        System.out.println("  " + list.subList(0, p + 1));
    }

    private void printStack(int[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Integer.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(long[] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(Long.toString(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    private void printStack(char[][] s, int p) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        while (i < p + 1) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(new String(s[i]));
            ++i;
        }
        buf.append("]");
        System.out.println("  " + buf);
    }

    public void display() {
    }

    @Override
    protected MethodDeclaration createMethodDeclaration(CompilationResult result) {
        return declarationFactory.createMethodDeclaration(result);
    }

    @Override
    protected ConstructorDeclaration createConstructorDeclaration(CompilationResult result) {
        return declarationFactory.createConstructorDeclaration(result);
    }

    @Override
    protected void consumeMethodInvocationName() {
        super.consumeMethodInvocationName();
        MessageSend m = (MessageSend)this.expressionStack[this.expressionPtr];
        if (CharOperation.equals(m.selector, "proceed".toCharArray())) {
            this.expressionStack[this.expressionPtr] = declarationFactory.createProceed(m);
        }
    }

    @Override
    protected void consumeToken(int type) {
        this.currentTokenStart = this.scanner.startPosition;
        super.consumeToken(type);
        switch (type) {
            case 26: {
                this.pushOnAspectIntStack(this.scanner.currentPosition - 1);
                this.pushOnAspectIntStack(this.scanner.startPosition);
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                this.pushIdentifier();
                this.scanner.commentPtr = -1;
            }
        }
    }

    protected void consumeAspectDeclaration() {
        this.consumeClassDeclaration();
    }

    protected void consumeAspectHeader() {
        this.consumeClassHeader();
    }

    protected void consumeAspectHeaderName(boolean isPrivileged) {
        TypeDeclaration aspectDecl = declarationFactory.createAspect(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                aspectDecl.bits |= 0x400;
            }
        } else {
            aspectDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.println("aspect header name: ");
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        aspectDecl.sourceEnd = (int)pos;
        aspectDecl.sourceStart = (int)(pos >>> 32);
        aspectDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        aspectDecl.declarationSourceStart = this.aspectIntStack[this.aspectIntPtr--];
        --this.aspectIntPtr;
        this.eatIdentifier();
        if (isPrivileged) {
            pos = this.eatIdentifier();
            declarationFactory.setPrivileged(aspectDecl, true);
        }
        aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        aspectDecl.modifiers = this.intStack[this.intPtr--];
        if (isPrivileged) {
            aspectDecl.modifiersSourceStart = this.intStack[this.intPtr--];
            aspectDecl.modifiers |= this.intStack[this.intPtr--];
        }
        if (aspectDecl.modifiersSourceStart >= 0) {
            aspectDecl.declarationSourceStart = aspectDecl.modifiersSourceStart;
        }
        this.println("modifiers: " + aspectDecl.modifiers);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            aspectDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, aspectDecl.annotations, 0, length);
        }
        aspectDecl.bodyStart = aspectDecl.sourceEnd + 1;
        this.pushOnAstStack(aspectDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = aspectDecl.bodyStart;
            this.currentElement = this.currentElement.add(aspectDecl, 0);
            this.lastIgnoredToken = -1;
        }
        aspectDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected void consumeAspectHeaderNameWithTypeParameters(boolean isPriviliged) {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private long eatIdentifier() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        --this.identifierPtr;
        --this.identifierLengthPtr;
        return pos;
    }

    protected void consumeAspectHeaderRest() {
        this.concatNodeLists();
        this.display();
        ASTNode pseudoTokens = this.popPseudoTokens("{");
        this.println("pseudo: " + pseudoTokens);
        TypeDeclaration aspectDecl = (TypeDeclaration)this.astStack[this.astPtr];
        declarationFactory.setDominatesPatternFrom(aspectDecl, pseudoTokens, this);
        declarationFactory.setPerClauseFrom(aspectDecl, pseudoTokens, this);
    }

    protected void consumePointcutDeclaration() {
        this.consumePointcutDesignatorOnDeclaration();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    public int getCurrentTokenStart() {
        return this.currentTokenStart;
    }

    protected void consumeEmptyPointcutDeclaration() {
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        pcutDecl.bodyEnd = this.endStatementPosition;
    }

    protected void consumePointcutHeader() {
        MethodDeclaration ret = declarationFactory.createPointcutDeclaration(this.compilationUnit.compilationResult);
        long pos = this.identifierPositionStack[this.identifierPtr];
        ret.sourceStart = (int)(pos >>> 32);
        ret.selector = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ret.javadoc = this.javadoc;
        this.javadoc = null;
        this.eatIdentifier();
        ret.declarationSourceStart = this.intStack[this.intPtr--];
        ret.modifiers = this.intStack[this.intPtr--];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            ret.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, ret.annotations, 0, length);
        }
        this.pushOnAstStack(ret);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeAroundDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeAroundHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
    }

    protected void consumeAroundHeaderName() {
        int length;
        MethodDeclaration adviceDecl = declarationFactory.createAroundAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        adviceDecl.returnType = returnType;
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
    }

    protected void consumePointcutDesignatorOnAdvice() {
        ASTNode des = this.popPointcutDesignator("{");
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnAdvice(adviceDecl, des);
        adviceDecl.sourceEnd = des.sourceEnd;
        adviceDecl.bodyStart = des.sourceEnd + 1;
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumePointcutDesignatorOnDeclaration() {
        ASTNode des = this.popPointcutDesignator(";");
        MethodDeclaration pcutDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setPointcutDesignatorOnPointcut(pcutDecl, des);
        pcutDecl.sourceEnd = des.sourceEnd;
        pcutDecl.bodyStart = des.sourceEnd + 1;
        pcutDecl.bodyEnd = this.endPosition;
        pcutDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceDeclaration() {
        this.consumeMethodDeclaration(true, false);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeader() {
        this.consumePointcutDesignatorOnAdvice();
        this.resetModifiers();
        this.consumeMethodHeader();
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeBasicAdviceHeaderName(boolean isAfter) {
        int length;
        MethodDeclaration adviceDecl = isAfter ? declarationFactory.createAfterAdviceDeclaration(this.compilationUnit.compilationResult) : declarationFactory.createBeforeAdviceDeclaration(this.compilationUnit.compilationResult);
        long pos = this.eatIdentifier();
        adviceDecl.selector = new char[]{'a', 'j', 'c', '$', 'a', 'd', 'v', 'i', 'c', 'e'};
        adviceDecl.sourceStart = (int)(pos >>> 32);
        adviceDecl.declarationSourceStart = this.intStack[this.intPtr--];
        adviceDecl.modifiers = this.intStack[this.intPtr--];
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            adviceDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, adviceDecl.annotations, 0, length);
        }
        adviceDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.pushOnAstStack(adviceDecl);
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$afterReturning$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$2$133468e6();
    }

    protected void consumeExtraParameterWithFormal() {
        Argument arg = (Argument)this.astStack[this.astPtr--];
        --this.astLengthPtr;
        declarationFactory.setExtraArgument((MethodDeclaration)this.astStack[this.astPtr], arg);
        this.consumeExtraParameterNoFormal();
    }

    protected void consumeExtraParameterNoFormal() {
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        MethodDeclaration adviceDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.isAfterAdvice(adviceDecl);
        if (CharOperation.equals(name, "throwing".toCharArray())) {
            declarationFactory.setAfterThrowingAdviceKind(adviceDecl);
        } else if (CharOperation.equals(name, "returning".toCharArray())) {
            declarationFactory.setAfterReturningAdviceKind(adviceDecl);
        } else {
            this.problemReporter().parseError(start, end, this.currentToken, name, String.valueOf(name), new String[]{"throwing", "returning", ":"});
        }
    }

    protected void consumeClassBodyDeclarationInAspect() {
    }

    protected void consumeDeclareDeclaration() {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        MethodDeclaration declareDecl = declarationFactory.createDeclareDeclaration(this.compilationUnit.compilationResult, tokens, this);
        this.display();
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotation(char kind) {
        this.concatNodeLists();
        ASTNode tokens = this.popPseudoTokens(";");
        Annotation[] annotations = new Annotation[1];
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, annotations, 0, length);
        }
        MethodDeclaration declareDecl = declarationFactory.createDeclareAnnotationDeclaration(this.compilationUnit.compilationResult, tokens, annotations[0], this, kind);
        this.pushOnAstStack(declareDecl);
    }

    protected void consumeDeclareAnnotationHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken("@", 0, false);
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeDeclareHeader() {
        this.consumePseudoTokenIdentifier();
        this.consumePseudoTokenIdentifier();
        this.swapAstStack();
        this.consumePseudoTokens();
        this.consumePseudoToken(":", 0, false);
        this.consumePseudoTokens();
        this.display();
    }

    protected void consumeInterTypeFieldHeader(boolean hasTypeParameters) {
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] identifierName = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        TypeReference returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        this.display();
        int decSourceStart = this.intStack[this.intPtr--];
        int fieldModifiers = this.intStack[this.intPtr--];
        MethodDeclaration dec = declarationFactory.createInterTypeFieldDeclaration(this.compilationUnit.compilationResult, onType);
        dec.returnType = returnType;
        dec.sourceStart = start;
        dec.sourceEnd = end;
        declarationFactory.setSelector(dec, identifierName);
        dec.declarationSourceStart = decSourceStart;
        declarationFactory.setDeclaredModifiers(dec, fieldModifiers);
        dec.bodyEnd = this.endPosition;
        dec.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            dec.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, dec.annotations, 0, length);
        }
        this.pushOnAstStack(dec);
        this.println("consumed field: " + dec);
        this.display();
    }

    protected void consumeExitITDVariableWithoutInitializer() {
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        declarationFactory.setInitialization(itdDecl, null);
    }

    protected void consumeExitITDVariableWithInitializer() {
        --this.expressionLengthPtr;
        MethodDeclaration itdDecl = (MethodDeclaration)this.astStack[this.astPtr];
        Expression initialization = this.expressionStack[this.expressionPtr--];
        declarationFactory.setInitialization(itdDecl, initialization);
        itdDecl.declarationSourceEnd = initialization.sourceEnd;
    }

    protected void consumeInterTypeFieldDeclaration() {
        MethodDeclaration dec = (MethodDeclaration)this.astStack[this.astPtr];
        dec.bodyEnd = this.endPosition;
        dec.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    protected void consumeInterTypeMethodDeclaration(boolean isNotAbstract) {
        this.consumeMethodDeclaration(isNotAbstract, false);
    }

    protected void consumeInterTypeMethodHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeConstructorDeclaration() {
        this.consumeMethodDeclaration(true, false);
    }

    protected void consumeInterTypeConstructorHeader() {
        this.consumeMethodHeader();
    }

    protected void consumeInterTypeMethodHeaderName(boolean hasMethodTypeParameters, boolean hasGenericTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeMethodDeclaration(this.compilationUnit.compilationResult);
        char[] name = this.identifierStack[this.identifierPtr];
        long selectorSource = this.identifierPositionStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (hasGenericTypeParameters) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        md.returnType = this.getTypeReference(this.intStack[this.intPtr--]);
        if (hasMethodTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        declarationFactory.setOnType(md, onType);
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        md.sourceStart = (int)(selectorSource >>> 32);
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        declarationFactory.setSelector(md, name);
        this.listLength = 0;
        md.javadoc = this.javadoc;
        this.javadoc = null;
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType || this.scanner.getLineNumber(md.returnType.sourceStart) == this.scanner.getLineNumber(md.sourceStart)) {
                this.lastCheckPoint = md.bodyStart;
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumeInterTypeConstructorHeaderName(boolean hasConstructorTypeParameters, boolean hasTargetTypeParameters) {
        this.display();
        MethodDeclaration md = declarationFactory.createInterTypeConstructorDeclaration(this.compilationUnit.compilationResult);
        if (!hasTargetTypeParameters) {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(md, onType);
        this.println("got onType: " + onType);
        this.display();
        --this.intPtr;
        md.returnType = TypeReference.baseTypeReference(6, 0, null);
        if (hasConstructorTypeParameters) {
            int tp_length = this.genericsLengthStack[this.genericsLengthPtr--];
            this.genericsPtr -= tp_length;
            md.typeParameters = new TypeParameter[tp_length];
            System.arraycopy(this.genericsStack, this.genericsPtr + 1, md.typeParameters, 0, tp_length);
        }
        md.declarationSourceStart = this.intStack[this.intPtr--];
        declarationFactory.setDeclaredModifiers(md, this.intStack[this.intPtr--]);
        int length = this.expressionLengthStack[this.expressionLengthPtr--];
        if (length != 0) {
            md.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, md.annotations, 0, length);
        }
        md.sourceStart = onType.sourceStart;
        this.pushOnAstStack(md);
        md.sourceEnd = this.lParenPos;
        md.bodyStart = this.lParenPos + 1;
        this.listLength = 0;
        declarationFactory.setSelector(md, (String.valueOf(new String(CharOperation.concatWith(onType.getTypeName(), '_'))) + "_new").toCharArray());
        if (this.currentElement != null) {
            if (this.currentElement instanceof RecoveredType) {
                this.currentElement = this.currentElement.add(md, 0);
                this.lastIgnoredToken = -1;
            } else {
                this.lastCheckPoint = md.sourceStart;
                this.restartRecovery = true;
            }
        }
    }

    protected void consumePseudoToken(String value) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(value, 0, false);
    }

    protected void consumePseudoToken(String value, int popFromIntStack, boolean isIdentifier) {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.intPtr -= popFromIntStack;
        int start = this.currentTokenStart;
        int end = start + value.length() - 1;
        ASTNode tok = declarationFactory.createPseudoToken(this, value, isIdentifier);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIdentifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        long pos = this.identifierPositionStack[this.identifierPtr];
        int end = (int)pos;
        int start = (int)(pos >>> 32);
        char[] name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(name), true);
        tok.sourceStart = start;
        tok.sourceEnd = end;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenIf() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Expression expr = this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        this.println("expr: " + expr);
        int start = this.intStack[this.intPtr--];
        ASTNode tok = declarationFactory.createIfPseudoToken(this, expr);
        tok.sourceStart = start;
        tok.sourceEnd = this.rParenPos;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenLiteral() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        Literal literal = (Literal)this.expressionStack[this.expressionPtr--];
        --this.expressionLengthPtr;
        ASTNode tok = declarationFactory.createPseudoToken(this, new String(literal.source()), false);
        declarationFactory.setLiteralKind(tok, "string");
        tok.sourceStart = literal.sourceStart;
        tok.sourceEnd = literal.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokenModifier() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.consumePseudoToken(Modifier.toString(this.modifiers), 0, true);
        this.modifiers = 0;
    }

    protected void consumePseudoTokenPrimitiveType() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        TypeReference type = this.getTypeReference(0);
        ASTNode tok = declarationFactory.createPseudoToken(this, type.toString(), true);
        tok.sourceStart = type.sourceStart;
        tok.sourceEnd = type.sourceEnd;
        this.pushOnAstStack(tok);
    }

    protected void consumePseudoTokens() {
        AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions.aspectOf().ajc$before$org_aspectj_ajdt_internal_compiler_parser_AllowAssertAndEnumAsIdentifierTokensInPointcutExpressions$1$8c8140c9();
        this.optimizedConcatNodeLists();
    }

    @Override
    protected void consumeRule(int act) {
        switch (act) {
            case 39: {
                this.consumePrimitiveType();
                break;
            }
            case 53: {
                this.consumeReferenceType();
                break;
            }
            case 57: {
                this.consumeClassOrInterfaceName();
                break;
            }
            case 58: {
                this.consumeClassOrInterface();
                break;
            }
            case 59: {
                this.consumeGenericType();
                break;
            }
            case 60: {
                this.consumeGenericTypeWithDiamond();
                break;
            }
            case 61: {
                this.consumeArrayTypeWithTypeArgumentsName();
                break;
            }
            case 62: {
                this.consumePrimitiveArrayType();
                break;
            }
            case 63: {
                this.consumeNameArrayType();
                break;
            }
            case 64: {
                this.consumeGenericTypeNameArrayType();
                break;
            }
            case 65: {
                this.consumeGenericTypeArrayType();
                break;
            }
            case 71: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 72: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 81: {
                this.consumeQualifiedName();
                break;
            }
            case 84: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 89: {
                this.consumeUnannotatableQualifiedName();
                break;
            }
            case 90: {
                this.consumeQualifiedName(false);
                break;
            }
            case 91: {
                this.consumeQualifiedName(true);
                break;
            }
            case 92: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 96: {
                this.consumeOneMoreTypeAnnotation();
                break;
            }
            case 97: {
                this.consumeTypeAnnotation();
                break;
            }
            case 98: {
                this.consumeTypeAnnotation();
                break;
            }
            case 99: {
                this.consumeTypeAnnotation();
                break;
            }
            case 100: {
                this.consumeAnnotationName();
                break;
            }
            case 101: {
                this.consumeNormalAnnotation(true);
                break;
            }
            case 102: {
                this.consumeMarkerAnnotation(true);
                break;
            }
            case 103: {
                this.consumeSingleMemberAnnotation(true);
                break;
            }
            case 104: {
                this.consumeNonTypeUseName();
                break;
            }
            case 105: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 106: {
                this.consumeExplicitThisParameter(false);
                break;
            }
            case 107: {
                this.consumeExplicitThisParameter(true);
                break;
            }
            case 108: {
                this.consumeVariableDeclaratorIdParameter();
                break;
            }
            case 109: {
                this.consumeCompilationUnit();
                break;
            }
            case 110: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 111: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 112: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 113: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 114: {
                this.consumeInternalCompilationUnit();
                break;
            }
            case 115: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 116: {
                this.consumeInternalCompilationUnitWithTypes();
                break;
            }
            case 117: {
                this.consumeEmptyInternalCompilationUnit();
                break;
            }
            case 118: {
                this.consumeReduceImports();
                break;
            }
            case 119: {
                this.consumeEnterCompilationUnit();
                break;
            }
            case 135: {
                this.consumeCatchHeader();
                break;
            }
            case 137: {
                this.consumeImportDeclarations();
                break;
            }
            case 139: {
                this.consumeTypeDeclarations();
                break;
            }
            case 140: {
                this.consumePackageDeclaration();
                break;
            }
            case 141: {
                this.consumePackageDeclarationNameWithModifiers();
                break;
            }
            case 142: {
                this.consumePackageDeclarationName();
                break;
            }
            case 143: {
                this.consumePackageComment();
                break;
            }
            case 148: {
                this.consumeImportDeclaration();
                break;
            }
            case 149: {
                this.consumeSingleTypeImportDeclarationName();
                break;
            }
            case 150: {
                this.consumeImportDeclaration();
                break;
            }
            case 151: {
                this.consumeTypeImportOnDemandDeclarationName();
                break;
            }
            case 154: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 158: {
                this.consumeModifiers2();
                break;
            }
            case 171: {
                this.consumeAnnotationAsModifier();
                break;
            }
            case 184: {
                this.consumeAspectDeclaration();
                break;
            }
            case 185: {
                this.consumeAspectHeader();
                break;
            }
            case 188: {
                this.consumeAspectHeaderNameWithTypeParameters(false);
                break;
            }
            case 189: {
                this.consumeAspectHeaderNameWithTypeParameters(true);
                break;
            }
            case 190: {
                this.consumeAspectHeaderName(false);
                break;
            }
            case 191: {
                this.consumeAspectHeaderName(true);
                break;
            }
            case 193: {
                this.consumeAspectHeaderRest();
                break;
            }
            case 194: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 197: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 198: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 199: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 200: {
                this.consumeClassBodyDeclarationInAspect();
                break;
            }
            case 204: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 214: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 216: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 217: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 218: {
                this.consumeMethodHeader();
                break;
            }
            case 219: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 220: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 221: {
                this.consumeEmptyPointcutDeclaration();
                break;
            }
            case 222: {
                this.consumePointcutDeclaration();
                break;
            }
            case 223: {
                this.consumePointcutHeader();
                break;
            }
            case 226: {
                this.consumeAroundDeclaration();
                break;
            }
            case 227: {
                this.consumeAroundHeader();
                break;
            }
            case 228: {
                this.consumeAroundHeaderName();
                break;
            }
            case 229: {
                this.consumeAroundHeaderNameMissingReturnType();
                break;
            }
            case 230: {
                this.consumeBasicAdviceDeclaration();
                break;
            }
            case 233: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 234: {
                this.consumeBasicAdviceHeader();
                break;
            }
            case 235: {
                this.consumeBasicAdviceHeaderName(false);
                break;
            }
            case 236: {
                this.consumeBasicAdviceHeaderName(true);
                break;
            }
            case 237: {
                this.consumeExtraParameterWithFormal();
                break;
            }
            case 238: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 239: {
                this.consumeExtraParameterNoFormal();
                break;
            }
            case 241: {
                this.consumeZeroTypeAnnotations();
                break;
            }
            case 242: {
                this.consumeZeroTypeAnnotations();
                this.consumeQualifiedName();
                break;
            }
            case 247: {
                this.consumeInterTypeMethodDeclaration(true);
                break;
            }
            case 248: {
                this.consumeInterTypeMethodHeader();
                break;
            }
            case 249: {
                this.consumeInterTypeMethodHeaderName(false, false);
                break;
            }
            case 250: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 251: {
                this.consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 252: {
                this.consumeInterTypeMethodHeaderName(false, true);
                break;
            }
            case 253: {
                this.consumeInterTypeMethodHeaderName(true, false);
                break;
            }
            case 254: {
                this.consumeInterTypeMethodHeaderName(true, true);
                break;
            }
            case 255: {
                this.consumeInterTypeMethodDeclaration(false);
                break;
            }
            case 256: {
                this.convertTypeParametersToSingleTypeReferences();
                break;
            }
            case 257: {
                this.consumeInterTypeConstructorDeclaration();
                break;
            }
            case 258: {
                this.consumeInterTypeConstructorHeader();
                break;
            }
            case 259: {
                this.consumeInterTypeConstructorHeaderName(false, false);
                break;
            }
            case 260: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("*");
                break;
            }
            case 261: {
                this.consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern("+");
                break;
            }
            case 262: {
                this.consumeInterTypeConstructorHeaderName(true, false);
                break;
            }
            case 263: {
                this.consumeInterTypeConstructorHeaderName(false, true);
                break;
            }
            case 264: {
                this.consumeInterTypeConstructorHeaderName(true, true);
                break;
            }
            case 265: {
                this.consumeInterTypeFieldDeclaration();
                break;
            }
            case 266: {
                this.consumeInterTypeFieldHeader(false);
                break;
            }
            case 267: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("*");
                break;
            }
            case 268: {
                this.consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern("+");
                break;
            }
            case 269: {
                this.consumeInterTypeFieldHeader(true);
                break;
            }
            case 270: {
                this.consumeExitITDVariableWithoutInitializer();
                break;
            }
            case 271: {
                this.consumeExitITDVariableWithInitializer();
                break;
            }
            case 273: {
                this.consumeDeclareDeclaration();
                break;
            }
            case 274: {
                this.consumeDeclareHeader();
                break;
            }
            case 275: {
                this.consumeDeclareAnnotation(' ');
                break;
            }
            case 276: {
                this.consumeDeclareAnnotation('+');
                break;
            }
            case 277: {
                this.consumeDeclareAnnotation('-');
                break;
            }
            case 280: {
                this.consumeDeclareAnnotationHeader();
                break;
            }
            case 283: {
                this.consumePseudoTokens();
                break;
            }
            case 284: {
                this.consumePseudoTokens();
                break;
            }
            case 286: {
                this.consumePseudoTokens();
                break;
            }
            case 287: {
                this.consumePseudoToken(":");
                break;
            }
            case 288: {
                this.consumePseudoTokenIdentifier();
                break;
            }
            case 289: {
                this.consumePseudoToken("(");
                break;
            }
            case 290: {
                this.consumePseudoToken(")");
                break;
            }
            case 291: {
                this.consumePseudoToken(".");
                break;
            }
            case 292: {
                this.consumePseudoToken("*");
                break;
            }
            case 293: {
                this.consumePseudoToken("+");
                break;
            }
            case 294: {
                this.consumePseudoToken("=");
                break;
            }
            case 295: {
                this.consumePseudoToken("&&");
                break;
            }
            case 296: {
                this.consumePseudoToken("||");
                break;
            }
            case 297: {
                this.consumePseudoToken("!");
                break;
            }
            case 298: {
                this.consumePseudoToken(",");
                break;
            }
            case 299: {
                this.consumePseudoToken("[");
                break;
            }
            case 300: {
                this.consumePseudoToken("]");
                break;
            }
            case 301: {
                this.consumePseudoToken("@");
                break;
            }
            case 302: {
                this.consumePseudoToken("...");
                break;
            }
            case 303: {
                this.consumePseudoToken("?");
                break;
            }
            case 304: {
                this.consumePseudoToken("<");
                break;
            }
            case 305: {
                this.consumePseudoToken(">");
                break;
            }
            case 306: {
                this.consumePseudoToken(">>");
                break;
            }
            case 307: {
                this.consumePseudoToken(">>>");
                break;
            }
            case 308: {
                this.consumePseudoToken("&");
                break;
            }
            case 309: {
                this.consumePseudoToken("!=");
                break;
            }
            case 310: {
                this.consumePseudoTokenPrimitiveType();
                break;
            }
            case 311: {
                this.consumePseudoTokenModifier();
                break;
            }
            case 312: {
                this.consumePseudoTokenLiteral();
                break;
            }
            case 313: {
                this.consumePseudoToken("this", 1, true);
                break;
            }
            case 314: {
                this.consumePseudoToken("class", 1, true);
                break;
            }
            case 315: {
                this.consumePseudoToken("super", 1, true);
                break;
            }
            case 316: {
                this.consumePseudoTokenIf();
                break;
            }
            case 317: {
                this.consumePseudoToken("assert", 1, true);
                break;
            }
            case 318: {
                this.consumePseudoToken("import", 1, true);
                break;
            }
            case 319: {
                this.consumePseudoToken("package", 1, true);
                break;
            }
            case 320: {
                this.consumePseudoToken("throw", 1, true);
                break;
            }
            case 321: {
                this.consumePseudoToken("new", 1, true);
                break;
            }
            case 322: {
                this.consumePseudoToken("do", 1, true);
                break;
            }
            case 323: {
                this.consumePseudoToken("for", 1, true);
                break;
            }
            case 324: {
                this.consumePseudoToken("switch", 1, true);
                break;
            }
            case 325: {
                this.consumePseudoToken("try", 1, true);
                break;
            }
            case 326: {
                this.consumePseudoToken("while", 1, true);
                break;
            }
            case 327: {
                this.consumePseudoToken("break", 1, true);
                break;
            }
            case 328: {
                this.consumePseudoToken("continue", 1, true);
                break;
            }
            case 329: {
                this.consumePseudoToken("return", 1, true);
                break;
            }
            case 330: {
                this.consumePseudoToken("case", 1, true);
                break;
            }
            case 331: {
                this.consumePseudoToken("catch", 0, true);
                break;
            }
            case 332: {
                this.consumePseudoToken("instanceof", 0, true);
                break;
            }
            case 333: {
                this.consumePseudoToken("else", 0, true);
                break;
            }
            case 334: {
                this.consumePseudoToken("extends", 0, true);
                break;
            }
            case 335: {
                this.consumePseudoToken("finally", 0, true);
                break;
            }
            case 336: {
                this.consumePseudoToken("implements", 0, true);
                break;
            }
            case 337: {
                this.consumePseudoToken("throws", 0, true);
                break;
            }
            case 338: {
                this.consumeClassDeclaration();
                break;
            }
            case 339: {
                this.consumeIntertypeClassDeclaration();
                break;
            }
            case 340: {
                this.consumeIntertypeClassHeader();
                break;
            }
            case 341: {
                this.consumeIntertypeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 343: {
                this.consumeIntertypeClassHeaderName(false);
                break;
            }
            case 344: {
                this.consumeIntertypeClassHeaderName(true);
                break;
            }
            case 345: {
                this.consumeClassHeader();
                break;
            }
            case 346: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 348: {
                this.consumeClassHeaderName1();
                break;
            }
            case 349: {
                this.consumeClassHeaderExtends();
                break;
            }
            case 350: {
                this.consumeClassHeaderImplements();
                break;
            }
            case 352: {
                this.consumeInterfaceTypeList();
                break;
            }
            case 353: {
                this.consumeInterfaceType();
                break;
            }
            case 356: {
                this.consumeClassBodyDeclarations();
                break;
            }
            case 360: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 361: {
                this.consumeDiet();
                break;
            }
            case 362: {
                this.consumeClassBodyDeclaration();
                break;
            }
            case 363: {
                this.consumeCreateInitializer();
                break;
            }
            case 370: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 373: {
                this.consumeFieldDeclaration();
                break;
            }
            case 375: {
                this.consumeVariableDeclarators();
                break;
            }
            case 378: {
                this.consumeEnterVariable();
                break;
            }
            case 379: {
                this.consumeExitVariableWithInitialization();
                break;
            }
            case 380: {
                this.consumeExitVariableWithoutInitialization();
                break;
            }
            case 381: {
                this.consumeForceNoDiet();
                break;
            }
            case 382: {
                this.consumeRestoreDiet();
                break;
            }
            case 387: {
                this.consumeMethodDeclaration(true, false);
                break;
            }
            case 388: {
                this.consumeMethodDeclaration(true, true);
                break;
            }
            case 389: {
                this.consumeMethodDeclaration(false, false);
                break;
            }
            case 390: {
                this.consumeMethodHeader();
                break;
            }
            case 391: {
                this.consumeMethodHeader();
                break;
            }
            case 392: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 393: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 394: {
                this.consumeMethodHeaderNameWithTypeParameters(false);
                break;
            }
            case 395: {
                this.consumeMethodHeaderName(false);
                break;
            }
            case 396: {
                this.consumePushCombineModifiers();
                break;
            }
            case 397: {
                this.consumeMethodHeaderRightParen();
                break;
            }
            case 398: {
                this.consumeMethodHeaderExtendedDims();
                break;
            }
            case 399: {
                this.consumeMethodHeaderThrowsClause();
                break;
            }
            case 400: {
                this.consumeConstructorHeader();
                break;
            }
            case 401: {
                this.consumeConstructorHeaderNameWithTypeParameters();
                break;
            }
            case 402: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 403: {
                this.consumeConstructorHeaderName();
                break;
            }
            case 405: {
                this.consumeFormalParameterList();
                break;
            }
            case 406: {
                this.consumeFormalParameter(false);
                break;
            }
            case 407: {
                this.consumeFormalParameter(true);
                break;
            }
            case 408: {
                this.consumeFormalParameter(true);
                break;
            }
            case 409: {
                this.consumeCatchFormalParameter();
                break;
            }
            case 410: {
                this.consumeCatchType();
                break;
            }
            case 411: {
                this.consumeUnionTypeAsClassType();
                break;
            }
            case 412: {
                this.consumeUnionType();
                break;
            }
            case 414: {
                this.consumeClassTypeList();
                break;
            }
            case 415: {
                this.consumeClassTypeElt();
                break;
            }
            case 416: {
                this.consumeMethodBody();
                break;
            }
            case 417: {
                this.consumeNestedMethod();
                break;
            }
            case 418: {
                this.consumeStaticInitializer();
                break;
            }
            case 419: {
                this.consumeStaticOnly();
                break;
            }
            case 420: {
                this.consumeConstructorDeclaration();
                break;
            }
            case 421: {
                this.consumeInvalidConstructorDeclaration();
                break;
            }
            case 422: {
                this.consumeExplicitConstructorInvocation(0, 3);
                break;
            }
            case 423: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 3);
                break;
            }
            case 424: {
                this.consumeExplicitConstructorInvocation(0, 2);
                break;
            }
            case 425: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(0, 2);
                break;
            }
            case 426: {
                this.consumeExplicitConstructorInvocation(1, 2);
                break;
            }
            case 427: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 2);
                break;
            }
            case 428: {
                this.consumeExplicitConstructorInvocation(2, 2);
                break;
            }
            case 429: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 2);
                break;
            }
            case 430: {
                this.consumeExplicitConstructorInvocation(1, 3);
                break;
            }
            case 431: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(1, 3);
                break;
            }
            case 432: {
                this.consumeExplicitConstructorInvocation(2, 3);
                break;
            }
            case 433: {
                this.consumeExplicitConstructorInvocationWithTypeArguments(2, 3);
                break;
            }
            case 434: {
                this.consumeInterfaceDeclaration();
                break;
            }
            case 435: {
                this.consumeInterfaceHeader();
                break;
            }
            case 436: {
                this.consumeTypeHeaderNameWithTypeParameters();
                break;
            }
            case 438: {
                this.consumeInterfaceHeaderName1();
                break;
            }
            case 439: {
                this.consumeInterfaceHeaderExtends();
                break;
            }
            case 442: {
                this.consumeInterfaceMemberDeclarations();
                break;
            }
            case 443: {
                this.consumeEmptyTypeDeclaration();
                break;
            }
            case 445: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 446: {
                this.consumeInterfaceMethodDeclaration(false);
                break;
            }
            case 447: {
                this.consumeInterfaceMethodDeclaration(true);
                break;
            }
            case 448: {
                this.consumeInvalidConstructorDeclaration(true);
                break;
            }
            case 449: {
                this.consumeInvalidConstructorDeclaration(false);
                break;
            }
            case 460: {
                this.consumePushLeftBrace();
                break;
            }
            case 461: {
                this.consumeEmptyArrayInitializer();
                break;
            }
            case 462: {
                this.consumeArrayInitializer();
                break;
            }
            case 463: {
                this.consumeArrayInitializer();
                break;
            }
            case 465: {
                this.consumeVariableInitializers();
                break;
            }
            case 466: {
                this.consumeBlock();
                break;
            }
            case 467: {
                this.consumeOpenBlock();
                break;
            }
            case 468: {
                this.consumeBlockStatement();
                break;
            }
            case 469: {
                this.consumeBlockStatements();
                break;
            }
            case 476: {
                this.consumeInvalidInterfaceDeclaration();
                break;
            }
            case 477: {
                this.consumeInvalidAnnotationTypeDeclaration();
                break;
            }
            case 478: {
                this.consumeInvalidEnumDeclaration();
                break;
            }
            case 479: {
                this.consumeLocalVariableDeclarationStatement();
                break;
            }
            case 480: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 481: {
                this.consumeLocalVariableDeclaration();
                break;
            }
            case 482: {
                this.consumePushModifiers();
                break;
            }
            case 483: {
                this.consumePushModifiersForHeader();
                break;
            }
            case 484: {
                this.consumePushRealModifiers();
                break;
            }
            case 511: {
                this.consumeEmptyStatement();
                break;
            }
            case 512: {
                this.consumeStatementLabel();
                break;
            }
            case 513: {
                this.consumeStatementLabel();
                break;
            }
            case 514: {
                this.consumeLabel();
                break;
            }
            case 515: {
                this.consumeExpressionStatement();
                break;
            }
            case 524: {
                this.consumeStatementIfNoElse();
                break;
            }
            case 525: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 526: {
                this.consumeStatementIfWithElse();
                break;
            }
            case 527: {
                this.consumeStatementSwitch();
                break;
            }
            case 528: {
                this.consumeEmptySwitchBlock();
                break;
            }
            case 531: {
                this.consumeSwitchBlock();
                break;
            }
            case 533: {
                this.consumeSwitchBlockStatements();
                break;
            }
            case 534: {
                this.consumeSwitchBlockStatement();
                break;
            }
            case 536: {
                this.consumeSwitchLabels();
                break;
            }
            case 537: {
                this.consumeCaseLabel();
                break;
            }
            case 538: {
                this.consumeDefaultLabel();
                break;
            }
            case 539: {
                this.consumeStatementWhile();
                break;
            }
            case 540: {
                this.consumeStatementWhile();
                break;
            }
            case 541: {
                this.consumeStatementDo();
                break;
            }
            case 542: {
                this.consumeStatementFor();
                break;
            }
            case 543: {
                this.consumeStatementFor();
                break;
            }
            case 544: {
                this.consumeForInit();
                break;
            }
            case 548: {
                this.consumeStatementExpressionList();
                break;
            }
            case 549: {
                this.consumeSimpleAssertStatement();
                break;
            }
            case 550: {
                this.consumeAssertStatement();
                break;
            }
            case 551: {
                this.consumeStatementBreak();
                break;
            }
            case 552: {
                this.consumeStatementBreakWithLabel();
                break;
            }
            case 553: {
                this.consumeStatementContinue();
                break;
            }
            case 554: {
                this.consumeStatementContinueWithLabel();
                break;
            }
            case 555: {
                this.consumeStatementReturn();
                break;
            }
            case 556: {
                this.consumeStatementThrow();
                break;
            }
            case 557: {
                this.consumeStatementSynchronized();
                break;
            }
            case 558: {
                this.consumeOnlySynchronized();
                break;
            }
            case 559: {
                this.consumeStatementTry(false, false);
                break;
            }
            case 560: {
                this.consumeStatementTry(true, false);
                break;
            }
            case 561: {
                this.consumeStatementTry(false, true);
                break;
            }
            case 562: {
                this.consumeStatementTry(true, true);
                break;
            }
            case 563: {
                this.consumeResourceSpecification();
                break;
            }
            case 564: {
                this.consumeResourceOptionalTrailingSemiColon(false);
                break;
            }
            case 565: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 566: {
                this.consumeSingleResource();
                break;
            }
            case 567: {
                this.consumeMultipleResources();
                break;
            }
            case 568: {
                this.consumeResourceOptionalTrailingSemiColon(true);
                break;
            }
            case 569: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 570: {
                this.consumeResourceAsLocalVariableDeclaration();
                break;
            }
            case 572: {
                this.consumeExitTryBlock();
                break;
            }
            case 574: {
                this.consumeCatches();
                break;
            }
            case 575: {
                this.consumeStatementCatch();
                break;
            }
            case 577: {
                this.consumeLeftParen();
                break;
            }
            case 578: {
                this.consumeRightParen();
                break;
            }
            case 583: {
                this.consumePrimaryNoNewArrayThis();
                break;
            }
            case 584: {
                this.consumePrimaryNoNewArray();
                break;
            }
            case 585: {
                this.consumePrimaryNoNewArrayWithName();
                break;
            }
            case 588: {
                this.consumePrimaryNoNewArrayNameThis();
                break;
            }
            case 589: {
                this.consumePrimaryNoNewArrayNameSuper();
                break;
            }
            case 590: {
                this.consumePrimaryNoNewArrayName();
                break;
            }
            case 591: {
                this.consumePrimaryNoNewArrayArrayType();
                break;
            }
            case 592: {
                this.consumePrimaryNoNewArrayPrimitiveArrayType();
                break;
            }
            case 593: {
                this.consumePrimaryNoNewArrayPrimitiveType();
                break;
            }
            case 599: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(false);
                break;
            }
            case 600: {
                this.consumeReferenceExpressionTypeArgumentsAndTrunk(true);
                break;
            }
            case 601: {
                this.consumeReferenceExpressionTypeForm(true);
                break;
            }
            case 602: {
                this.consumeReferenceExpressionTypeForm(false);
                break;
            }
            case 603: {
                this.consumeReferenceExpressionGenericTypeForm();
                break;
            }
            case 604: {
                this.consumeReferenceExpressionPrimaryForm();
                break;
            }
            case 605: {
                this.consumeReferenceExpressionSuperForm();
                break;
            }
            case 606: {
                this.consumeEmptyTypeArguments();
                break;
            }
            case 608: {
                this.consumeIdentifierOrNew(false);
                break;
            }
            case 609: {
                this.consumeIdentifierOrNew(true);
                break;
            }
            case 610: {
                this.consumeLambdaExpression();
                break;
            }
            case 611: {
                this.consumeNestedLambda();
                break;
            }
            case 612: {
                this.consumeTypeElidedLambdaParameter(false);
                break;
            }
            case 618: {
                this.consumeFormalParameterList();
                break;
            }
            case 619: {
                this.consumeTypeElidedLambdaParameter(true);
                break;
            }
            case 622: {
                this.consumeElidedLeftBraceAndReturn();
                break;
            }
            case 623: {
                this.consumeAllocationHeader();
                break;
            }
            case 624: {
                this.consumeClassInstanceCreationExpressionWithTypeArguments();
                break;
            }
            case 625: {
                this.consumeClassInstanceCreationExpression();
                break;
            }
            case 626: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 627: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 628: {
                this.consumeClassInstanceCreationExpressionQualified();
                break;
            }
            case 629: {
                this.consumeClassInstanceCreationExpressionQualifiedWithTypeArguments();
                break;
            }
            case 630: {
                this.consumeEnterInstanceCreationArgumentList();
                break;
            }
            case 631: {
                this.consumeClassInstanceCreationExpressionName();
                break;
            }
            case 632: {
                this.consumeClassBodyopt();
                break;
            }
            case 634: {
                this.consumeEnterAnonymousClassBody(false);
                break;
            }
            case 635: {
                this.consumeClassBodyopt();
                break;
            }
            case 637: {
                this.consumeEnterAnonymousClassBody(true);
                break;
            }
            case 639: {
                this.consumeArgumentList();
                break;
            }
            case 640: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 641: {
                this.consumeArrayCreationHeader();
                break;
            }
            case 642: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 643: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 644: {
                this.consumeArrayCreationExpressionWithoutInitializer();
                break;
            }
            case 645: {
                this.consumeArrayCreationExpressionWithInitializer();
                break;
            }
            case 647: {
                this.consumeDimWithOrWithOutExprs();
                break;
            }
            case 649: {
                this.consumeDimWithOrWithOutExpr();
                break;
            }
            case 650: {
                this.consumeDims();
                break;
            }
            case 653: {
                this.consumeOneDimLoop(false);
                break;
            }
            case 654: {
                this.consumeOneDimLoop(true);
                break;
            }
            case 655: {
                this.consumeFieldAccess(false);
                break;
            }
            case 656: {
                this.consumeFieldAccess(true);
                break;
            }
            case 657: {
                this.consumeMethodInvocationName();
                break;
            }
            case 658: {
                this.consumeMethodInvocationNameWithTypeArguments();
                break;
            }
            case 659: {
                this.consumeMethodInvocationPrimaryWithTypeArguments();
                break;
            }
            case 660: {
                this.consumeMethodInvocationPrimary();
                break;
            }
            case 661: {
                this.consumeMethodInvocationSuperWithTypeArguments();
                break;
            }
            case 662: {
                this.consumeMethodInvocationSuper();
                break;
            }
            case 663: {
                this.consumeArrayAccess(true);
                break;
            }
            case 664: {
                this.consumeArrayAccess(true);
                break;
            }
            case 665: {
                this.consumeArrayAccess(false);
                break;
            }
            case 666: {
                this.consumeArrayAccess(false);
                break;
            }
            case 668: {
                this.consumePostfixExpression();
                break;
            }
            case 671: {
                this.consumeUnaryExpression(14, true);
                break;
            }
            case 672: {
                this.consumeUnaryExpression(13, true);
                break;
            }
            case 673: {
                this.consumePushPosition();
                break;
            }
            case 676: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 677: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 679: {
                this.consumeUnaryExpression(14, false);
                break;
            }
            case 680: {
                this.consumeUnaryExpression(13, false);
                break;
            }
            case 682: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 683: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 685: {
                this.consumeCastExpressionWithPrimitiveType();
                break;
            }
            case 686: {
                this.consumeCastExpressionWithGenericsArray();
                break;
            }
            case 687: {
                this.consumeCastExpressionWithQualifiedGenericsArray();
                break;
            }
            case 688: {
                this.consumeCastExpressionLL1();
                break;
            }
            case 689: {
                this.consumeCastExpressionLL1WithBounds();
                break;
            }
            case 690: {
                this.consumeCastExpressionWithNameArray();
                break;
            }
            case 691: {
                this.consumeZeroAdditionalBounds();
                break;
            }
            case 695: {
                this.consumeOnlyTypeArgumentsForCastExpression();
                break;
            }
            case 696: {
                this.consumeInsideCastExpression();
                break;
            }
            case 697: {
                this.consumeInsideCastExpressionLL1();
                break;
            }
            case 698: {
                this.consumeInsideCastExpressionLL1WithBounds();
                break;
            }
            case 699: {
                this.consumeInsideCastExpressionWithQualifiedGenerics();
                break;
            }
            case 701: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 702: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 703: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 705: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 706: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 708: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 709: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 710: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 712: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 713: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 714: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 715: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 717: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 719: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 720: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 722: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 724: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 726: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 728: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 730: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 732: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 735: {
                this.consumeAssignment();
                break;
            }
            case 737: {
                this.ignoreExpressionAssignment();
                break;
            }
            case 738: {
                this.consumeAssignmentOperator(30);
                break;
            }
            case 739: {
                this.consumeAssignmentOperator(15);
                break;
            }
            case 740: {
                this.consumeAssignmentOperator(9);
                break;
            }
            case 741: {
                this.consumeAssignmentOperator(16);
                break;
            }
            case 742: {
                this.consumeAssignmentOperator(14);
                break;
            }
            case 743: {
                this.consumeAssignmentOperator(13);
                break;
            }
            case 744: {
                this.consumeAssignmentOperator(10);
                break;
            }
            case 745: {
                this.consumeAssignmentOperator(17);
                break;
            }
            case 746: {
                this.consumeAssignmentOperator(19);
                break;
            }
            case 747: {
                this.consumeAssignmentOperator(2);
                break;
            }
            case 748: {
                this.consumeAssignmentOperator(8);
                break;
            }
            case 749: {
                this.consumeAssignmentOperator(3);
                break;
            }
            case 750: {
                this.consumeExpression();
                break;
            }
            case 753: {
                this.consumeEmptyExpression();
                break;
            }
            case 758: {
                this.consumeEmptyClassBodyDeclarationsopt();
                break;
            }
            case 759: {
                this.consumeClassBodyDeclarationsopt();
                break;
            }
            case 760: {
                this.consumeDefaultModifiers();
                break;
            }
            case 761: {
                this.consumeModifiers();
                break;
            }
            case 762: {
                this.consumeEmptyBlockStatementsopt();
                break;
            }
            case 764: {
                this.consumeEmptyDimsopt();
                break;
            }
            case 766: {
                this.consumeEmptyArgumentListopt();
                break;
            }
            case 770: {
                this.consumeFormalParameterListopt();
                break;
            }
            case 774: {
                this.consumeEmptyInterfaceMemberDeclarationsopt();
                break;
            }
            case 775: {
                this.consumeInterfaceMemberDeclarationsopt();
                break;
            }
            case 776: {
                this.consumeNestedType();
                break;
            }
            case 777: {
                this.consumeEmptyForInitopt();
                break;
            }
            case 779: {
                this.consumeEmptyForUpdateopt();
                break;
            }
            case 783: {
                this.consumeEmptyCatchesopt();
                break;
            }
            case 785: {
                this.consumeEnumDeclaration();
                break;
            }
            case 786: {
                this.consumeEnumHeader();
                break;
            }
            case 787: {
                this.consumeEnumHeaderName();
                break;
            }
            case 788: {
                this.consumeEnumHeaderNameWithTypeParameters();
                break;
            }
            case 789: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 790: {
                this.consumeEnumBodyNoConstants();
                break;
            }
            case 791: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 792: {
                this.consumeEnumBodyWithConstants();
                break;
            }
            case 794: {
                this.consumeEnumConstants();
                break;
            }
            case 795: {
                this.consumeEnumConstantHeaderName();
                break;
            }
            case 796: {
                this.consumeEnumConstantHeader();
                break;
            }
            case 797: {
                this.consumeEnumConstantWithClassBody();
                break;
            }
            case 798: {
                this.consumeEnumConstantNoClassBody();
                break;
            }
            case 799: {
                this.consumeArguments();
                break;
            }
            case 800: {
                this.consumeEmptyArguments();
                break;
            }
            case 802: {
                this.consumeEnumDeclarations();
                break;
            }
            case 803: {
                this.consumeEmptyEnumDeclarations();
                break;
            }
            case 805: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 806: {
                this.consumeEnhancedForStatement();
                break;
            }
            case 807: {
                this.consumeEnhancedForStatementHeaderInit(false);
                break;
            }
            case 808: {
                this.consumeEnhancedForStatementHeaderInit(true);
                break;
            }
            case 809: {
                this.consumeEnhancedForStatementHeader();
                break;
            }
            case 810: {
                this.consumeImportDeclaration();
                break;
            }
            case 811: {
                this.consumeSingleStaticImportDeclarationName();
                break;
            }
            case 812: {
                this.consumeImportDeclaration();
                break;
            }
            case 813: {
                this.consumeStaticImportOnDemandDeclarationName();
                break;
            }
            case 814: {
                this.consumeTypeArguments();
                break;
            }
            case 815: {
                this.consumeOnlyTypeArguments();
                break;
            }
            case 817: {
                this.consumeTypeArgumentList1();
                break;
            }
            case 819: {
                this.consumeTypeArgumentList();
                break;
            }
            case 820: {
                this.consumeTypeArgument();
                break;
            }
            case 824: {
                this.consumeReferenceType1();
                break;
            }
            case 825: {
                this.consumeTypeArgumentReferenceType1();
                break;
            }
            case 827: {
                this.consumeTypeArgumentList2();
                break;
            }
            case 830: {
                this.consumeReferenceType2();
                break;
            }
            case 831: {
                this.consumeTypeArgumentReferenceType2();
                break;
            }
            case 833: {
                this.consumeTypeArgumentList3();
                break;
            }
            case 836: {
                this.consumeReferenceType3();
                break;
            }
            case 837: {
                this.consumeWildcard();
                break;
            }
            case 838: {
                this.consumeWildcardWithBounds();
                break;
            }
            case 839: {
                this.consumeWildcardBoundsExtends();
                break;
            }
            case 840: {
                this.consumeWildcardBoundsSuper();
                break;
            }
            case 841: {
                this.consumeWildcard1();
                break;
            }
            case 842: {
                this.consumeWildcard1WithBounds();
                break;
            }
            case 843: {
                this.consumeWildcardBounds1Extends();
                break;
            }
            case 844: {
                this.consumeWildcardBounds1Super();
                break;
            }
            case 845: {
                this.consumeWildcard2();
                break;
            }
            case 846: {
                this.consumeWildcard2WithBounds();
                break;
            }
            case 847: {
                this.consumeWildcardBounds2Extends();
                break;
            }
            case 848: {
                this.consumeWildcardBounds2Super();
                break;
            }
            case 849: {
                this.consumeWildcard3();
                break;
            }
            case 850: {
                this.consumeWildcard3WithBounds();
                break;
            }
            case 851: {
                this.consumeWildcardBounds3Extends();
                break;
            }
            case 852: {
                this.consumeWildcardBounds3Super();
                break;
            }
            case 853: {
                this.consumeTypeParameterHeader();
                break;
            }
            case 854: {
                this.consumeTypeParameters();
                break;
            }
            case 856: {
                this.consumeTypeParameterList();
                break;
            }
            case 858: {
                this.consumeTypeParameterWithExtends();
                break;
            }
            case 859: {
                this.consumeTypeParameterWithExtendsAndBounds();
                break;
            }
            case 861: {
                this.consumeAdditionalBoundList();
                break;
            }
            case 862: {
                this.consumeAdditionalBound();
                break;
            }
            case 864: {
                this.consumeTypeParameterList1();
                break;
            }
            case 865: {
                this.consumeTypeParameter1();
                break;
            }
            case 866: {
                this.consumeTypeParameter1WithExtends();
                break;
            }
            case 867: {
                this.consumeTypeParameter1WithExtendsAndBounds();
                break;
            }
            case 869: {
                this.consumeAdditionalBoundList1();
                break;
            }
            case 870: {
                this.consumeAdditionalBound1();
                break;
            }
            case 876: {
                this.consumeUnaryExpression(14);
                break;
            }
            case 877: {
                this.consumeUnaryExpression(13);
                break;
            }
            case 880: {
                this.consumeUnaryExpression(12);
                break;
            }
            case 881: {
                this.consumeUnaryExpression(11);
                break;
            }
            case 884: {
                this.consumeBinaryExpression(15);
                break;
            }
            case 885: {
                this.consumeBinaryExpressionWithName(15);
                break;
            }
            case 886: {
                this.consumeBinaryExpression(9);
                break;
            }
            case 887: {
                this.consumeBinaryExpressionWithName(9);
                break;
            }
            case 888: {
                this.consumeBinaryExpression(16);
                break;
            }
            case 889: {
                this.consumeBinaryExpressionWithName(16);
                break;
            }
            case 891: {
                this.consumeBinaryExpression(14);
                break;
            }
            case 892: {
                this.consumeBinaryExpressionWithName(14);
                break;
            }
            case 893: {
                this.consumeBinaryExpression(13);
                break;
            }
            case 894: {
                this.consumeBinaryExpressionWithName(13);
                break;
            }
            case 896: {
                this.consumeBinaryExpression(10);
                break;
            }
            case 897: {
                this.consumeBinaryExpressionWithName(10);
                break;
            }
            case 898: {
                this.consumeBinaryExpression(17);
                break;
            }
            case 899: {
                this.consumeBinaryExpressionWithName(17);
                break;
            }
            case 900: {
                this.consumeBinaryExpression(19);
                break;
            }
            case 901: {
                this.consumeBinaryExpressionWithName(19);
                break;
            }
            case 903: {
                this.consumeBinaryExpression(4);
                break;
            }
            case 904: {
                this.consumeBinaryExpressionWithName(4);
                break;
            }
            case 905: {
                this.consumeBinaryExpression(6);
                break;
            }
            case 906: {
                this.consumeBinaryExpressionWithName(6);
                break;
            }
            case 907: {
                this.consumeBinaryExpression(5);
                break;
            }
            case 908: {
                this.consumeBinaryExpressionWithName(5);
                break;
            }
            case 909: {
                this.consumeBinaryExpression(7);
                break;
            }
            case 910: {
                this.consumeBinaryExpressionWithName(7);
                break;
            }
            case 912: {
                this.consumeInstanceOfExpressionWithName();
                break;
            }
            case 913: {
                this.consumeInstanceOfExpression();
                break;
            }
            case 915: {
                this.consumeEqualityExpression(18);
                break;
            }
            case 916: {
                this.consumeEqualityExpressionWithName(18);
                break;
            }
            case 917: {
                this.consumeEqualityExpression(29);
                break;
            }
            case 918: {
                this.consumeEqualityExpressionWithName(29);
                break;
            }
            case 920: {
                this.consumeBinaryExpression(2);
                break;
            }
            case 921: {
                this.consumeBinaryExpressionWithName(2);
                break;
            }
            case 923: {
                this.consumeBinaryExpression(8);
                break;
            }
            case 924: {
                this.consumeBinaryExpressionWithName(8);
                break;
            }
            case 926: {
                this.consumeBinaryExpression(3);
                break;
            }
            case 927: {
                this.consumeBinaryExpressionWithName(3);
                break;
            }
            case 929: {
                this.consumeBinaryExpression(0);
                break;
            }
            case 930: {
                this.consumeBinaryExpressionWithName(0);
                break;
            }
            case 932: {
                this.consumeBinaryExpression(1);
                break;
            }
            case 933: {
                this.consumeBinaryExpressionWithName(1);
                break;
            }
            case 935: {
                this.consumeConditionalExpression(23);
                break;
            }
            case 936: {
                this.consumeConditionalExpressionWithName(23);
                break;
            }
            case 940: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 941: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 942: {
                this.consumeAnnotationTypeDeclarationHeaderNameWithTypeParameters();
                break;
            }
            case 943: {
                this.consumeAnnotationTypeDeclarationHeaderName();
                break;
            }
            case 944: {
                this.consumeAnnotationTypeDeclarationHeader();
                break;
            }
            case 945: {
                this.consumeAnnotationTypeDeclaration();
                break;
            }
            case 947: {
                this.consumeEmptyAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 948: {
                this.consumeAnnotationTypeMemberDeclarationsopt();
                break;
            }
            case 950: {
                this.consumeAnnotationTypeMemberDeclarations();
                break;
            }
            case 951: {
                this.consumeMethodHeaderNameWithTypeParameters(true);
                break;
            }
            case 952: {
                this.consumeMethodHeaderName(true);
                break;
            }
            case 953: {
                this.consumeEmptyMethodHeaderDefaultValue();
                break;
            }
            case 954: {
                this.consumeMethodHeaderDefaultValue();
                break;
            }
            case 955: {
                this.consumeMethodHeader();
                break;
            }
            case 956: {
                this.consumeAnnotationTypeMemberDeclaration();
                break;
            }
            case 964: {
                this.consumeAnnotationName();
                break;
            }
            case 965: {
                this.consumeNormalAnnotation(false);
                break;
            }
            case 966: {
                this.consumeEmptyMemberValuePairsopt();
                break;
            }
            case 969: {
                this.consumeMemberValuePairs();
                break;
            }
            case 970: {
                this.consumeMemberValuePair();
                break;
            }
            case 971: {
                this.consumeEnterMemberValue();
                break;
            }
            case 972: {
                this.consumeExitMemberValue();
                break;
            }
            case 974: {
                this.consumeMemberValueAsName();
                break;
            }
            case 977: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 978: {
                this.consumeMemberValueArrayInitializer();
                break;
            }
            case 979: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 980: {
                this.consumeEmptyMemberValueArrayInitializer();
                break;
            }
            case 981: {
                this.consumeEnterMemberValueArrayInitializer();
                break;
            }
            case 983: {
                this.consumeMemberValues();
                break;
            }
            case 984: {
                this.consumeMarkerAnnotation(false);
                break;
            }
            case 985: {
                this.consumeSingleMemberAnnotationMemberValue();
                break;
            }
            case 986: {
                this.consumeSingleMemberAnnotation(false);
                break;
            }
            case 987: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 988: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 989: {
                this.consumeRecoveryMethodHeaderNameWithTypeParameters();
                break;
            }
            case 990: {
                this.consumeRecoveryMethodHeaderName();
                break;
            }
            case 991: {
                this.consumeMethodHeader();
                break;
            }
            case 992: {
                this.consumeMethodHeader();
            }
        }
    }

    protected void consumeQualifiedName() {
        this.consumeQualifiedName(false);
    }

    private void consumeIntertypeClassHeader() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        if (this.currentToken == 65) {
            typeDecl.bodyStart = this.scanner.currentPosition;
        }
        if (this.currentElement != null) {
            this.restartRecovery = true;
        }
        this.scanner.commentPtr = -1;
    }

    private void consumeIntertypeClassDeclaration() {
        TypeDeclaration typeDecl;
        boolean hasConstructor;
        int length;
        if ((length = this.astLengthStack[this.astLengthPtr--]) != 0) {
            this.dispatchDeclarationInto(length);
        }
        if (!(hasConstructor = (typeDecl = (TypeDeclaration)this.astStack[this.astPtr]).checkConstructors(this))) {
            switch (TypeDeclaration.kind(typeDecl.modifiers)) {
                case 1: 
                case 3: {
                    boolean insideFieldInitializer = false;
                    if (this.diet) {
                        int i = this.nestedType;
                        while (i > 0) {
                            if (this.variablesCounter[i] > 0) {
                                insideFieldInitializer = true;
                                break;
                            }
                            --i;
                        }
                    }
                    typeDecl.createDefaultConstructor(!this.diet || insideFieldInitializer, true);
                }
            }
        }
        if (this.scanner.containsAssertKeyword) {
            typeDecl.bits |= 1;
        }
        typeDecl.addClinit();
        typeDecl.bodyEnd = this.endStatementPosition;
        if (length == 0 && !this.containsComment(typeDecl.bodyStart, typeDecl.bodyEnd)) {
            typeDecl.bits |= 8;
        }
        typeDecl.declarationSourceEnd = this.flushCommentsDefinedPriorTo(this.endStatementPosition);
    }

    private void consumeIntertypeTypeHeaderNameWithTypeParameters() {
        TypeDeclaration typeDecl = (TypeDeclaration)this.astStack[this.astPtr];
        int length = this.genericsLengthStack[this.genericsLengthPtr--];
        this.genericsPtr -= length;
        typeDecl.typeParameters = new TypeParameter[length];
        System.arraycopy(this.genericsStack, this.genericsPtr + 1, typeDecl.typeParameters, 0, length);
        typeDecl.bodyStart = typeDecl.typeParameters[length - 1].declarationSourceEnd + 1;
        this.listTypeParameterLength = 0;
        if (this.currentElement != null) {
            RecoveredType recoveredType = (RecoveredType)this.currentElement;
            recoveredType.pendingTypeParameters = null;
            this.lastCheckPoint = typeDecl.bodyStart;
        }
    }

    private void consumeIntertypeClassHeaderName(boolean b) {
        int length;
        TypeDeclaration typeDecl = declarationFactory.createIntertypeMemberClassDeclaration(this.compilationUnit.compilationResult);
        if (this.nestedMethod[this.nestedType] == 0) {
            if (this.nestedType != 0) {
                typeDecl.bits |= 0x400;
            }
        } else {
            typeDecl.bits |= 0x100;
            this.markEnclosingMemberWithLocalType();
            this.blockReal();
        }
        this.display();
        long pos = this.identifierPositionStack[this.identifierPtr];
        typeDecl.sourceEnd = (int)pos;
        typeDecl.sourceStart = (int)(pos >>> 32);
        typeDecl.name = this.identifierStack[this.identifierPtr--];
        --this.identifierLengthPtr;
        if (b) {
            this.pushOnGenericsIdentifiersLengthStack(this.identifierLengthStack[this.identifierLengthPtr]);
        } else {
            this.consumeClassOrInterfaceName();
        }
        TypeReference onType = this.getTypeReference(0);
        declarationFactory.setOnType(typeDecl, onType);
        typeDecl.declarationSourceStart = this.intStack[this.intPtr--];
        --this.intPtr;
        typeDecl.modifiersSourceStart = this.intStack[this.intPtr--];
        typeDecl.modifiers = this.intStack[this.intPtr--];
        if (typeDecl.modifiersSourceStart >= 0) {
            typeDecl.declarationSourceStart = typeDecl.modifiersSourceStart;
        }
        if ((typeDecl.bits & 0x400) == 0 && (typeDecl.bits & 0x100) == 0 && this.compilationUnit != null && !CharOperation.equals(typeDecl.name, this.compilationUnit.getMainTypeName())) {
            typeDecl.bits |= 0x1000;
        }
        if ((length = this.expressionLengthStack[this.expressionLengthPtr--]) != 0) {
            typeDecl.annotations = new Annotation[length];
            System.arraycopy(this.expressionStack, (this.expressionPtr -= length) + 1, typeDecl.annotations, 0, length);
        }
        typeDecl.bodyStart = typeDecl.sourceEnd + 1;
        this.pushOnAstStack(typeDecl);
        this.listLength = 0;
        if (this.currentElement != null) {
            this.lastCheckPoint = typeDecl.bodyStart;
            this.currentElement = this.currentElement.add(typeDecl, 0);
            this.lastIgnoredToken = -1;
        }
        typeDecl.javadoc = this.javadoc;
        this.javadoc = null;
        this.display();
    }

    protected ASTNode popPointcutDesignator(String terminator) {
        ASTNode tokens = this.popPseudoTokens(terminator);
        return declarationFactory.createPointcutDesignator(this, tokens);
    }

    protected ASTNode popPseudoTokens(String terminator) {
        this.consumePseudoToken(terminator);
        this.consumePseudoTokens();
        int length = this.astLengthStack[this.astLengthPtr--];
        this.astPtr -= length;
        ASTNode[] tokens = new ASTNode[length];
        System.arraycopy(this.astStack, this.astPtr + 1, tokens, 0, length);
        this.listLength = 0;
        return declarationFactory.createPseudoTokensFrom(tokens, this.compilationUnit.compilationResult());
    }

    private void swapAstStack() {
        ASTNode next;
        ASTNode top = this.astStack[this.astPtr];
        this.astStack[this.astPtr] = next = this.astStack[this.astPtr - 1];
        this.astStack[this.astPtr - 1] = top;
    }

    private void consumeInterTypeFieldHeaderIllegallyAttemptingToUseATypePattern(String badToken) {
        this.consumeInterTypeFieldHeader(false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 18, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeConstructorHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeConstructorHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 18, badToken.toCharArray(), badToken);
    }

    private void consumeInterTypeMethodHeaderNameIllegallyUsingTypePattern(String badToken) {
        this.consumeInterTypeMethodHeaderName(false, false);
        MethodDeclaration errorNode = (MethodDeclaration)this.astStack[this.astPtr];
        this.problemReporter().parseErrorDeleteToken(errorNode.sourceStart - 2, errorNode.sourceStart, 18, badToken.toCharArray(), badToken);
    }

    private void consumeAroundHeaderNameMissingReturnType() {
        this.problemReporter().parseErrorInsertToComplete(this.scanner.startPosition, this.scanner.currentPosition, "return type", "around advice declaration");
        this.restartRecovery = true;
    }

    private void consumeBadHeader() {
        this.problemReporter().parseErrorReplaceTokens(this.scanner.startPosition, this.scanner.currentPosition, "valid member declaration");
        this.restartRecovery = true;
    }

    @Override
    protected void consumeSimpleAssertStatement() {
        super.consumeSimpleAssertStatement();
    }

    private void convertTypeParametersToSingleTypeReferences() {
        int typeParameterIndex = 0;
        while (typeParameterIndex < this.genericsLengthStack[this.genericsLengthPtr]) {
            TypeParameter tp = (TypeParameter)this.genericsStack[this.genericsPtr - typeParameterIndex];
            SingleTypeReference str = new SingleTypeReference(tp.name, tp.declarationSourceStart);
            this.genericsStack[this.genericsPtr - typeParameterIndex] = str;
            ++typeParameterIndex;
        }
    }

    public Parser() {
    }

    public Parser(ProblemReporter problemReporter, boolean optimizeStringLiterals) {
        super(problemReporter, optimizeStringLiterals);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean shouldTryToRecover() {
        ASTNode aSTNode;
        int index = 0;
        while (index < this.astStack.length && (aSTNode = this.astStack[index++]) != null) {
            void node;
            if (declarationFactory.shouldTryToRecover((ASTNode)node)) continue;
            return false;
        }
        return true;
    }

    protected void pushOnAspectIntStack(int pos) {
        int stackLength = this.aspectIntStack.length;
        if (++this.aspectIntPtr >= stackLength) {
            this.aspectIntStack = new int[stackLength + 255];
            System.arraycopy(this.aspectIntStack, 0, this.aspectIntStack, 0, stackLength);
        }
        this.aspectIntStack[this.aspectIntPtr] = pos;
    }

    public static interface IDeclarationFactory {
        public MessageSend createProceed(MessageSend var1);

        public TypeDeclaration createAspect(CompilationResult var1);

        public void setPrivileged(TypeDeclaration var1, boolean var2);

        public void setPerClauseFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public void setDominatesPatternFrom(TypeDeclaration var1, ASTNode var2, Parser var3);

        public ASTNode createPseudoTokensFrom(ASTNode[] var1, CompilationResult var2);

        public MethodDeclaration createMethodDeclaration(CompilationResult var1);

        public ConstructorDeclaration createConstructorDeclaration(CompilationResult var1);

        public MethodDeclaration createPointcutDeclaration(CompilationResult var1);

        public MethodDeclaration createAroundAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createAfterAdviceDeclaration(CompilationResult var1);

        public MethodDeclaration createBeforeAdviceDeclaration(CompilationResult var1);

        public ASTNode createPointcutDesignator(Parser var1, ASTNode var2);

        public void setPointcutDesignatorOnAdvice(MethodDeclaration var1, ASTNode var2);

        public void setPointcutDesignatorOnPointcut(MethodDeclaration var1, ASTNode var2);

        public void setExtraArgument(MethodDeclaration var1, Argument var2);

        public boolean isAfterAdvice(MethodDeclaration var1);

        public void setAfterThrowingAdviceKind(MethodDeclaration var1);

        public void setAfterReturningAdviceKind(MethodDeclaration var1);

        public MethodDeclaration createDeclareDeclaration(CompilationResult var1, ASTNode var2, Parser var3);

        public MethodDeclaration createDeclareAnnotationDeclaration(CompilationResult var1, ASTNode var2, Annotation var3, Parser var4, char var5);

        public MethodDeclaration createInterTypeFieldDeclaration(CompilationResult var1, TypeReference var2);

        public MethodDeclaration createInterTypeMethodDeclaration(CompilationResult var1);

        public MethodDeclaration createInterTypeConstructorDeclaration(CompilationResult var1);

        public void setSelector(MethodDeclaration var1, char[] var2);

        public void setDeclaredModifiers(MethodDeclaration var1, int var2);

        public void setInitialization(MethodDeclaration var1, Expression var2);

        public void setOnType(MethodDeclaration var1, TypeReference var2);

        public ASTNode createPseudoToken(Parser var1, String var2, boolean var3);

        public ASTNode createIfPseudoToken(Parser var1, Expression var2);

        public void setLiteralKind(ASTNode var1, String var2);

        public boolean shouldTryToRecover(ASTNode var1);

        public TypeDeclaration createIntertypeMemberClassDeclaration(CompilationResult var1);

        public void setOnType(TypeDeclaration var1, TypeReference var2);
    }
}

