/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.scala.DataSet;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.python.PythonOptions;
import org.apache.flink.python.util.ResourceUtil;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableUtils;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.api.java.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.api.scala.BatchTableEnvironment;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.delegation.PlannerFactory;
import org.apache.flink.table.factories.ComponentFactoryService;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableAggregateFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.FlinkException;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.FlinkVersion;
import org.apache.zeppelin.flink.shims110.CollectStreamTableSink;
import org.apache.zeppelin.flink.shims110.Flink110ScalaShims;
import org.apache.zeppelin.flink.sql.SqlCommandParser;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Flink110Shims
extends FlinkShims {
    private static final Logger LOGGER = LoggerFactory.getLogger(Flink110Shims.class);
    public static final AttributedString MESSAGE_HELP = new AttributedStringBuilder().append((CharSequence)"The following commands are available:\n\n").append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.CREATE_TABLE, (String)"Create table under current catalog and database.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DROP_TABLE, (String)"Drop table with optional catalog and database. Syntax: 'DROP TABLE [IF EXISTS] <name>;'")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.CREATE_VIEW, (String)"Creates a virtual table from a SQL query. Syntax: 'CREATE VIEW <name> AS <query>;'")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DESCRIBE, (String)"Describes the schema of a table with the given name.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.DROP_VIEW, (String)"Deletes a previously created virtual table. Syntax: 'DROP VIEW <name>;'")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.EXPLAIN, (String)"Describes the execution plan of a query or table with the given name.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.HELP, (String)"Prints the available commands.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.INSERT_INTO, (String)"Inserts the results of a SQL SELECT query into a declared table sink.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.INSERT_OVERWRITE, (String)"Inserts the results of a SQL SELECT query into a declared table sink and overwrite existing data.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SELECT, (String)"Executes a SQL SELECT query on the Flink cluster.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SET, (String)"Sets a session configuration property. Syntax: 'SET <key>=<value>;'. Use 'SET;' for listing all properties.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SHOW_FUNCTIONS, (String)"Shows all user-defined and built-in functions.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SHOW_TABLES, (String)"Shows all registered tables.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.SOURCE, (String)"Reads a SQL SELECT query from a file and executes it on the Flink cluster.")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.USE_CATALOG, (String)"Sets the current catalog. The current database is set to the catalog's default one. Experimental! Syntax: 'USE CATALOG <name>;'")).append(Flink110Shims.formatCommand((SqlCommandParser.SqlCommand)SqlCommandParser.SqlCommand.USE, (String)"Sets the current default database. Experimental! Syntax: 'USE <name>;'")).style(AttributedStyle.DEFAULT.underline()).append((CharSequence)"\nHint").style(AttributedStyle.DEFAULT).append((CharSequence)": Make sure that a statement ends with ';' for finalizing (multi-line) statements.").toAttributedString();

    public Flink110Shims(FlinkVersion flinkVersion, Properties properties) {
        super(flinkVersion, properties);
    }

    public void disableSysoutLogging(Object batchConfig, Object streamConfig) {
        ((ExecutionConfig)batchConfig).disableSysoutLogging();
        ((ExecutionConfig)streamConfig).disableSysoutLogging();
    }

    public Object createStreamExecutionEnvironmentFactory(final Object streamExecutionEnvironment) {
        return new StreamExecutionEnvironmentFactory(){

            public StreamExecutionEnvironment createExecutionEnvironment() {
                return (StreamExecutionEnvironment)streamExecutionEnvironment;
            }
        };
    }

    public Object createCatalogManager(Object config) {
        return new CatalogManager("default_catalog", (Catalog)new GenericInMemoryCatalog("default_catalog", "default_database"));
    }

    public String getPyFlinkPythonPath(Properties properties) throws IOException {
        String flinkHome = System.getenv("FLINK_HOME");
        if (flinkHome != null) {
            File tmpDir = Files.createTempDirectory("zeppelin", new FileAttribute[0]).toFile();
            List depFiles = null;
            try {
                depFiles = ResourceUtil.extractBuiltInDependencies((String)tmpDir.getAbsolutePath(), (String)"pyflink", (boolean)true);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            StringBuilder builder = new StringBuilder();
            for (File file : depFiles) {
                LOGGER.info("Adding extracted file to PYTHONPATH: " + file.getAbsolutePath());
                builder.append(file.getAbsolutePath() + ":");
            }
            return builder.toString();
        }
        throw new IOException("No FLINK_HOME is specified");
    }

    public Object getCollectStreamTableSink(InetAddress targetAddress, int targetPort, Object serializer) {
        return new CollectStreamTableSink(targetAddress, targetPort, (TypeSerializer<Tuple2<Boolean, Row>>)((TypeSerializer)serializer));
    }

    public List collectToList(Object table) throws Exception {
        return TableUtils.collectToList((Table)((Table)table));
    }

    public void startMultipleInsert(Object tblEnv, InterpreterContext context) throws Exception {
    }

    public void addInsertStatement(String sql, Object tblEnv, InterpreterContext context) throws Exception {
        ((TableEnvironment)tblEnv).sqlUpdate(sql);
    }

    public boolean executeMultipleInsertInto(String jobName, Object tblEnv, InterpreterContext context) throws Exception {
        ((TableEnvironment)tblEnv).execute(jobName);
        return true;
    }

    public boolean rowEquals(Object row1, Object row2) {
        return ((Row)row1).equals((Object)((Row)row2));
    }

    public Object fromDataSet(Object btenv, Object ds) {
        return Flink110ScalaShims.fromDataSet((BatchTableEnvironment)btenv, (DataSet)ds);
    }

    public Object toDataSet(Object btenv, Object table) {
        return Flink110ScalaShims.toDataSet((BatchTableEnvironment)btenv, (Table)table);
    }

    public void registerTableSink(Object stenv, String tableName, Object collectTableSink) {
        ((TableEnvironment)stenv).registerTableSink(tableName, (TableSink)collectTableSink);
    }

    public void registerScalarFunction(Object btenv, String name, Object scalarFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (ScalarFunction)scalarFunction);
    }

    public void registerTableFunction(Object btenv, String name, Object tableFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableFunction)tableFunction);
    }

    public void registerAggregateFunction(Object btenv, String name, Object aggregateFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (AggregateFunction)aggregateFunction);
    }

    public void registerTableAggregateFunction(Object btenv, String name, Object tableAggregateFunction) {
        ((StreamTableEnvironmentImpl)btenv).registerFunction(name, (TableAggregateFunction)tableAggregateFunction);
    }

    public Optional<SqlCommandParser.SqlCommandCall> parseSql(Object tableEnv, String stmt) {
        for (SqlCommandParser.SqlCommand cmd : SqlCommandParser.SqlCommand.values()) {
            Matcher matcher;
            if (cmd.pattern == null || !(matcher = cmd.pattern.matcher(stmt)).matches()) continue;
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            if (cmd == SqlCommandParser.SqlCommand.EXPLAIN) {
                String[] operands2 = (String[])((Optional)cmd.operandConverter.apply(groups)).get();
                if (operands2[0].equalsIgnoreCase("select")) {
                    String[] newOperands = new String[]{operands2[0] + " " + operands2[1]};
                    return Optional.of(new SqlCommandParser.SqlCommandCall(cmd, newOperands, stmt));
                }
                return Optional.empty();
            }
            return ((Optional)cmd.operandConverter.apply(groups)).map(operands -> new SqlCommandParser.SqlCommandCall(cmd, operands, stmt));
        }
        return Optional.empty();
    }

    public void executeSql(Object tableEnv, String sql) {
        throw new RuntimeException("Should not be called for flink 1.10");
    }

    public String explain(Object tableEnv, String sql) {
        Table table = ((TableEnvironment)tableEnv).sqlQuery(sql);
        return ((TableEnvironment)tableEnv).explain(table);
    }

    public String sqlHelp() {
        return MESSAGE_HELP.toString();
    }

    public void setCatalogManagerSchemaResolver(Object catalogManager, Object parser, Object environmentSetting) {
    }

    public Object updateEffectiveConfig(Object cliFrontend, Object commandLine, Object effectiveConfig) {
        CustomCommandLine customCommandLine = null;
        try {
            customCommandLine = ((CliFrontend)cliFrontend).validateAndGetActiveCommandLine((CommandLine)commandLine);
        }
        catch (NoSuchMethodError e) {
            try {
                Method method = CliFrontend.class.getMethod("getActiveCustomCommandLine", CommandLine.class);
                customCommandLine = (CustomCommandLine)method.invoke((Object)((CliFrontend)cliFrontend), commandLine);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                LOGGER.error("Fail to call getCustomCli", (Throwable)ex);
                throw new RuntimeException("Fail to call getCustomCli", ex);
            }
        }
        try {
            return customCommandLine.applyCommandLineOptionsToConfiguration((CommandLine)commandLine);
        }
        catch (FlinkException e) {
            throw new RuntimeException("Fail to call applyCommandLineOptionsToConfiguration", e);
        }
    }

    public Map extractTableConfigOptions() {
        HashMap<String, ConfigOption> configOptions = new HashMap<String, ConfigOption>();
        configOptions.putAll(this.extractConfigOptions(ExecutionConfigOptions.class));
        configOptions.putAll(this.extractConfigOptions(OptimizerConfigOptions.class));
        try {
            configOptions.putAll(this.extractConfigOptions(PythonOptions.class));
        }
        catch (NoClassDefFoundError e) {
            LOGGER.warn("No pyflink jars found");
        }
        return configOptions;
    }

    private Map<String, ConfigOption> extractConfigOptions(Class clazz) {
        Field[] fields;
        HashMap<String, ConfigOption> configOptions = new HashMap<String, ConfigOption>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(ConfigOption.class)) continue;
            try {
                ConfigOption configOption = (ConfigOption)field.get(ConfigOption.class);
                configOptions.put(configOption.key(), configOption);
            }
            catch (Throwable e) {
                LOGGER.warn("Fail to get ConfigOption", e);
            }
        }
        return configOptions;
    }

    public String[] rowToString(Object row, Object table, Object tableConfig) {
        return this.rowToString((Row)row);
    }

    private String[] rowToString(Row row) {
        String[] fields = new String[row.getArity()];
        for (int i = 0; i < row.getArity(); ++i) {
            Object field = row.getField(i);
            fields[i] = field == null ? "(NULL)" : EncodingUtils.objectToString((Object)field);
        }
        return fields;
    }

    public boolean isTimeIndicatorType(Object type) {
        return FlinkTypeFactory.isTimeIndicatorType((TypeInformation)((TypeInformation)type));
    }

    private Object lookupExecutor(ClassLoader classLoader, Object settings, Object sEnv) {
        try {
            Map executorProperties = ((EnvironmentSettings)settings).toExecutorProperties();
            ExecutorFactory executorFactory = (ExecutorFactory)ComponentFactoryService.find(ExecutorFactory.class, (Map)executorProperties);
            Method createMethod = executorFactory.getClass().getMethod("create", Map.class, StreamExecutionEnvironment.class);
            return (Executor)createMethod.invoke((Object)executorFactory, executorProperties, (StreamExecutionEnvironment)sEnv);
        }
        catch (Exception e) {
            throw new TableException("Could not instantiate the executor. Make sure a planner module is on the classpath", (Throwable)e);
        }
    }

    public ImmutablePair<Object, Object> createPlannerAndExecutor(ClassLoader classLoader, Object environmentSettings, Object sEnv, Object tableConfig, Object functionCatalog, Object catalogManager) {
        EnvironmentSettings settings = (EnvironmentSettings)environmentSettings;
        Executor executor = (Executor)this.lookupExecutor(classLoader, settings, sEnv);
        Map plannerProperties = settings.toPlannerProperties();
        Planner planner = ((PlannerFactory)ComponentFactoryService.find(PlannerFactory.class, (Map)plannerProperties)).create(plannerProperties, executor, (TableConfig)tableConfig, (FunctionCatalog)functionCatalog, (CatalogManager)catalogManager);
        return ImmutablePair.of((Object)planner, (Object)executor);
    }
}

