/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFPage;

public class PDFPages
extends PDFObject {
    protected List kids = new ArrayList();
    protected int count;

    public PDFPages(PDFDocument document) {
        this.setObjectNumber(document);
    }

    public void addPage(PDFPage page) {
        page.setParent(this);
        this.incrementCount();
    }

    public void notifyKidRegistered(PDFPage page) {
        int idx = page.getPageIndex();
        if (idx >= 0) {
            while (idx > this.kids.size() - 1) {
                this.kids.add(null);
            }
            if (this.kids.get(idx) != null) {
                throw new IllegalStateException("A page already exists at index " + idx + " (zero-based).");
            }
            this.kids.set(idx, page.makeReference());
        } else {
            this.kids.add(page.makeReference());
        }
    }

    public int getCount() {
        return this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<< /Type /Pages\n/Count ").append(this.getCount()).append("\n/Kids [");
        for (int i = 0; i < this.kids.size(); ++i) {
            Object kid = this.kids.get(i);
            if (kid == null) {
                throw new IllegalStateException("Gap in the kids list!");
            }
            sb.append(kid).append(" ");
        }
        sb.append("] >>");
        return sb.toString();
    }
}

