/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.access.TilesAccess;
import org.apache.tiles.request.ApplicationContext;
import org.apache.tiles.request.Request;
import org.apache.tiles.request.reflect.CannotInstantiateObjectException;
import org.apache.tiles.request.reflect.ClassUtil;
import org.apache.tiles.request.servlet.ServletUtil;
import org.apache.tiles.web.util.AttributeContextMutator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilesDecorationFilter
implements Filter {
    public static final String CONTAINER_KEY_INIT_PARAMETER = "org.apache.tiles.web.util.TilesDecorationFilter.CONTAINER_KEY";
    private Logger log = LoggerFactory.getLogger(TilesDecorationFilter.class);
    private FilterConfig filterConfig;
    private String containerKey;
    private String definitionAttributeName = "content";
    private String definitionName = "layout";
    private String preventDecorationToken;
    private Map<String, String> alternateDefinitions;
    private AttributeContextMutator mutator = null;
    private ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.servletContext = this.filterConfig.getServletContext();
        this.containerKey = this.filterConfig.getInitParameter(CONTAINER_KEY_INIT_PARAMETER);
        String temp = config.getInitParameter("attribute-name");
        if (temp != null) {
            this.definitionAttributeName = temp;
        }
        if ((temp = config.getInitParameter("definition")) != null) {
            this.definitionName = temp;
        }
        temp = config.getInitParameter("prevent-token");
        this.preventDecorationToken = "org.apache.tiles.decoration.PREVENT:" + (temp == null ? this.definitionName : temp);
        this.alternateDefinitions = this.parseAlternateDefinitions();
        temp = config.getInitParameter("mutator");
        if (temp != null) {
            try {
                this.mutator = (AttributeContextMutator)ClassUtil.instantiate((String)temp);
            }
            catch (CannotInstantiateObjectException e) {
                throw new ServletException("Unable to instantiate specified context mutator.", (Throwable)e);
            }
        } else {
            this.mutator = new DefaultMutator();
        }
    }

    protected Map<String, String> parseAlternateDefinitions() {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration e = this.filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String parm = (String)e.nextElement();
            if (!parm.startsWith("definition(") || !parm.endsWith("*)")) continue;
            String value = this.filterConfig.getInitParameter(parm);
            String mask = parm.substring("definition(".length());
            mask = mask.substring(0, mask.lastIndexOf("*)"));
            map.put(mask, value);
            this.log.info("Mapping all requests matching '" + mask + "*' to definition '" + value + "'");
        }
        return map;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain filterChain) throws IOException, ServletException {
        if (!this.isPreventTokenPresent(req)) {
            ApplicationContext applicationContext = ServletUtil.getApplicationContext((ServletContext)this.servletContext);
            org.apache.tiles.request.servlet.ServletRequest request = new org.apache.tiles.request.servlet.ServletRequest(applicationContext, (HttpServletRequest)req, (HttpServletResponse)res);
            TilesContainer container = TilesAccess.getContainer((ApplicationContext)applicationContext, (String)this.containerKey);
            this.mutator.mutate(container.getAttributeContext((Request)request), req);
            if (this.preventDecorationToken != null) {
                req.setAttribute(this.preventDecorationToken, (Object)Boolean.TRUE);
            }
            String definitionName = this.getDefinitionForRequest(req);
            container.render(definitionName, (Request)request);
        }
        filterChain.doFilter(req, res);
    }

    private String getDefinitionForRequest(ServletRequest request) {
        if (this.alternateDefinitions.size() < 1) {
            return this.definitionName;
        }
        String base = this.getRequestBase(request);
        for (Map.Entry<String, String> pair : this.alternateDefinitions.entrySet()) {
            if (!base.startsWith(pair.getKey())) continue;
            return pair.getValue();
        }
        return this.definitionName;
    }

    private String getRequestBase(ServletRequest request) {
        String include = (String)request.getAttribute("javax.servlet.include.servlet_path");
        if (include != null) {
            return include;
        }
        return ((HttpServletRequest)request).getServletPath();
    }

    private boolean isPreventTokenPresent(ServletRequest request) {
        return this.preventDecorationToken != null && request.getAttribute(this.preventDecorationToken) != null;
    }

    class DefaultMutator
    implements AttributeContextMutator {
        DefaultMutator() {
        }

        @Override
        public void mutate(AttributeContext ctx, ServletRequest req) {
            Attribute attr = new Attribute();
            attr.setRenderer("template");
            attr.setValue((Object)TilesDecorationFilter.this.getRequestBase(req));
            ctx.putAttribute(TilesDecorationFilter.this.definitionAttributeName, attr);
        }
    }
}

