/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openssh.kdf;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKdfOptions;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public class RawKdfOptions
implements OpenSSHKdfOptions {
    private String name;
    private byte[] options;

    @Override
    public void initialize(String name, byte[] kdfOptions) throws IOException {
        this.setName(name);
        this.setOptions(this.options);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getOptions() {
        return NumberUtils.emptyIfNull(this.options);
    }

    public void setOptions(byte[] options) {
        this.options = NumberUtils.emptyIfNull(options);
    }

    @Override
    public boolean isEncrypted() {
        return !IS_NONE_KDF.test(this.getName());
    }

    @Override
    public byte[] decodePrivateKeyBytes(SessionContext session, NamedResource resourceKey, String cipherName, byte[] privateDataBytes, String password) throws IOException, GeneralSecurityException {
        throw new NoSuchAlgorithmException("Unsupported KDF algorithm (" + this.getName() + ")");
    }

    public int hashCode() {
        return GenericUtils.hashCode(this.getName(), Boolean.FALSE) + Arrays.hashCode(this.getOptions());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RawKdfOptions other = (RawKdfOptions)obj;
        return GenericUtils.safeCompare(this.getName(), other.getName(), false) == 0 && Arrays.equals(this.getOptions(), other.getOptions());
    }

    public String toString() {
        return this.getName() + ": options=" + BufferUtils.toHex(':', this.getOptions());
    }
}

