/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.document.wordprocessing;

import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Picture {
    private static Logger logger = Logger.getLogger((String)"org.openxml4j");

    public static boolean isPicture(String tag) {
        if (tag == null) {
            return false;
        }
        return tag.equals("pict");
    }

    public static boolean isPicture(Node nodeToCheck) {
        return Picture.isPicture(nodeToCheck.getName());
    }

    private static boolean isShape(String tag) {
        if (tag == null) {
            return false;
        }
        return tag.equals("shape");
    }

    private static boolean isImageData(String tag) {
        if (tag == null) {
            return false;
        }
        return tag.equals("imagedata");
    }

    public static boolean isIdTag(String tag) {
        if (tag == null) {
            return false;
        }
        return tag.equals("id");
    }

    private static boolean updateId(Element nodeToSearch, TreeMap<String, String> mapOldIdToNewId) {
        Iterator i = nodeToSearch.elementIterator();
        while (i.hasNext()) {
            Element child = (Element)i.next();
            if (!Picture.isShape(child.getName())) continue;
            Iterator j = child.elementIterator();
            while (j.hasNext()) {
                Element childOfShape = (Element)j.next();
                if (!Picture.isImageData(childOfShape.getName())) continue;
                Attribute attr = childOfShape.attribute("id");
                String newId = mapOldIdToNewId.get(attr.getStringValue());
                if (newId == null) {
                    logger.error((Object)("cannot find new id for id=" + attr.getStringValue()));
                    return false;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("found image id=" + attr.getStringValue() + " replaced by " + newId));
                }
                attr.setValue(newId);
                return true;
            }
        }
        logger.warn((Object)("no id found for " + nodeToSearch.getName()));
        return false;
    }

    public static void getListReferenceForImages(Element nodeToInsert, List<Element> listImageNodes) {
        Iterator i = nodeToInsert.elementIterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            List listOfChild = element.elements();
            if (listOfChild.size() == 0) {
                Picture.checkPictureTagAndAddToList(listImageNodes, element);
                continue;
            }
            if (Picture.checkPictureTagAndAddToList(listImageNodes, element)) {
                return;
            }
            for (Element child : listOfChild) {
                if (Picture.checkPictureTagAndAddToList(listImageNodes, child)) {
                    return;
                }
                Picture.getListReferenceForImages(child, listImageNodes);
            }
        }
    }

    private static boolean checkPictureTagAndAddToList(List<Element> listImageNodes, Element element) {
        if (element.getName().equals("pict")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("found a picture :" + element.asXML()));
            }
            listImageNodes.add(element);
            return true;
        }
        return false;
    }

    public static boolean addNewReferences(List<Element> listOfImages, TreeMap<String, String> mapOldIdToNewId) {
        for (Element pictureElement : listOfImages) {
            if (Picture.updateId(pictureElement, mapOldIdToNewId)) continue;
            logger.error((Object)"aborting because of error");
            return false;
        }
        return true;
    }
}

