/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.Lock;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.partition.PartitionTimeExtractor;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.RowDataToObjectArrayConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExpire {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExpire.class);
    private final List<String> partitionKeys;
    private final RowDataToObjectArrayConverter toObjectArrayConverter;
    private final Duration expirationTime;
    private final Duration checkInterval;
    private final PartitionTimeExtractor timeExtractor;
    private final FileStoreScan scan;
    private final FileStoreCommit commit;
    private LocalDateTime lastCheck;

    public PartitionExpire(RowType partitionType, Duration expirationTime, Duration checkInterval, String timePattern, String timeFormatter, FileStoreScan scan, FileStoreCommit commit) {
        this.partitionKeys = partitionType.getFieldNames();
        this.toObjectArrayConverter = new RowDataToObjectArrayConverter(partitionType);
        this.expirationTime = expirationTime;
        this.checkInterval = checkInterval;
        this.timeExtractor = new PartitionTimeExtractor(timePattern, timeFormatter);
        this.scan = scan;
        this.commit = commit;
        this.lastCheck = LocalDateTime.now();
    }

    public PartitionExpire withLock(Lock lock) {
        this.commit.withLock(lock);
        return this;
    }

    public void expire(long commitIdentifier) {
        this.expire(LocalDateTime.now(), commitIdentifier);
    }

    @VisibleForTesting
    void setLastCheck(LocalDateTime time) {
        this.lastCheck = time;
    }

    @VisibleForTesting
    void expire(LocalDateTime now, long commitIdentifier) {
        if (now.isAfter(this.lastCheck.plus(this.checkInterval))) {
            this.doExpire(now.minus(this.expirationTime), commitIdentifier);
            this.lastCheck = now;
        }
    }

    private void doExpire(LocalDateTime expireDateTime, long commitIdentifier) {
        ArrayList<Map<String, String>> expired = new ArrayList<Map<String, String>>();
        for (BinaryRow partition : this.readPartitions(expireDateTime)) {
            Object[] array = this.toObjectArrayConverter.convert(partition);
            Map<String, String> partString = this.toPartitionString(array);
            expired.add(partString);
            LOG.info("Expire Partition: " + partition);
        }
        if (expired.size() > 0) {
            this.commit.dropPartitions(expired, commitIdentifier);
        }
    }

    private Map<String, String> toPartitionString(Object[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.partitionKeys.size(); ++i) {
            map.put(this.partitionKeys.get(i), array[i].toString());
        }
        return map;
    }

    private List<BinaryRow> readPartitions(LocalDateTime expireDateTime) {
        return this.scan.withPartitionFilter(new PartitionTimePredicate(expireDateTime)).listPartitions();
    }

    private class PartitionTimePredicate
    implements PartitionPredicate {
        private final LocalDateTime expireDateTime;

        private PartitionTimePredicate(LocalDateTime expireDateTime) {
            this.expireDateTime = expireDateTime;
        }

        @Override
        public boolean test(BinaryRow partition) {
            Object[] array = PartitionExpire.this.toObjectArrayConverter.convert(partition);
            LocalDateTime partTime = PartitionExpire.this.timeExtractor.extract(PartitionExpire.this.partitionKeys, Arrays.asList(array));
            return partTime != null && this.expireDateTime.isAfter(partTime);
        }

        @Override
        public boolean test(long rowCount, InternalRow minValues, InternalRow maxValues, InternalArray nullCounts) {
            return true;
        }
    }
}

