/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import opennlp.maxent.GIS;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.model.AbstractModel;
import opennlp.model.Event;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.tools.coref.resolver.ResolverUtils;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.GenderEnum;
import opennlp.tools.coref.sim.TestGenderModel;
import opennlp.tools.coref.sim.TrainSimilarityModel;
import opennlp.tools.util.CollectionEventStream;
import opennlp.tools.util.HashList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenderModel
implements TestGenderModel,
TrainSimilarityModel {
    private int maleIndex;
    private int femaleIndex;
    private int neuterIndex;
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List<Event> events;
    private boolean debugOn = true;
    private Set<String> maleNames;
    private Set<String> femaleNames;

    public static TestGenderModel testModel(String name) throws IOException {
        GenderModel gm = new GenderModel(name, false);
        return gm;
    }

    public static TrainSimilarityModel trainModel(String name) throws IOException {
        GenderModel gm = new GenderModel(name, true);
        return gm;
    }

    private Set<String> readNames(String nameFile) throws IOException {
        HashSet<String> names = new HashSet<String>();
        BufferedReader nameReader = new BufferedReader(new FileReader(nameFile));
        String line = nameReader.readLine();
        while (line != null) {
            names.add(line);
            line = nameReader.readLine();
        }
        return names;
    }

    private GenderModel(String modelName, boolean train) throws IOException {
        this.modelName = modelName;
        this.maleNames = this.readNames(modelName + ".mas");
        this.femaleNames = this.readNames(modelName + ".fem");
        if (train) {
            this.events = new ArrayList<Event>();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(modelName + this.modelExtension)).getModel();
            this.maleIndex = this.testModel.getIndex(GenderEnum.MALE.toString());
            this.femaleIndex = this.testModel.getIndex(GenderEnum.FEMALE.toString());
            this.neuterIndex = this.testModel.getIndex(GenderEnum.NEUTER.toString());
        }
    }

    private List<String> getFeatures(Context np1) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("default");
        int tl = np1.getHeadTokenIndex();
        for (int ti = 0; ti < tl; ++ti) {
            features.add("mw=" + np1.getTokens()[ti].toString());
        }
        features.add("hw=" + np1.getHeadTokenText());
        features.add("n=" + np1.getNameType());
        if (np1.getNameType() != null && np1.getNameType().equals("person")) {
            Object[] tokens = np1.getTokens();
            for (int ti = 0; ti < np1.getHeadTokenIndex() || ti == 0; ++ti) {
                String name = tokens[ti].toString().toLowerCase();
                if (this.femaleNames.contains(name)) {
                    features.add("fem");
                }
                if (!this.maleNames.contains(name)) continue;
                features.add("mas");
            }
        }
        for (String si : np1.getSynsets()) {
            features.add("ss=" + si);
        }
        return features;
    }

    private void addEvent(String outcome, Context np1) {
        List<String> feats = this.getFeatures(np1);
        this.events.add(new Event(outcome, feats.toArray(new String[feats.size()])));
    }

    private GenderEnum getGender(Context mention) {
        if (ResolverUtils.malePronounPattern.matcher(mention.getHeadTokenText()).matches()) {
            return GenderEnum.MALE;
        }
        if (ResolverUtils.femalePronounPattern.matcher(mention.getHeadTokenText()).matches()) {
            return GenderEnum.FEMALE;
        }
        if (ResolverUtils.neuterPronounPattern.matcher(mention.getHeadTokenText()).matches()) {
            return GenderEnum.NEUTER;
        }
        Object[] mtokens = mention.getTokens();
        int tl = mtokens.length - 1;
        for (int ti = 0; ti < tl; ++ti) {
            String token = mtokens[ti].toString();
            if (token.equals("Mr.") || token.equals("Mr")) {
                return GenderEnum.MALE;
            }
            if (!token.equals("Mrs.") && !token.equals("Mrs") && !token.equals("Ms.") && !token.equals("Ms")) continue;
            return GenderEnum.FEMALE;
        }
        return GenderEnum.UNKNOWN;
    }

    private GenderEnum getGender(List<Context> entity) {
        for (Context ec : entity) {
            GenderEnum ge = this.getGender(ec);
            if (ge == GenderEnum.UNKNOWN) continue;
            return ge;
        }
        return GenderEnum.UNKNOWN;
    }

    @Override
    public void setExtents(Context[] extentContexts) {
        HashList entities = new HashList();
        ArrayList<Context> singletons = new ArrayList<Context>();
        for (Context ec : extentContexts) {
            if (ec.getId() != -1) {
                entities.put((Object)ec.getId(), ec);
                continue;
            }
            singletons.add(ec);
        }
        ArrayList<Context> males = new ArrayList<Context>();
        ArrayList<Context> females = new ArrayList<Context>();
        ArrayList<Context> eunuches = new ArrayList<Context>();
        for (Integer key : entities.keySet()) {
            List entityContexts = (List)entities.get(key);
            GenderEnum gender = this.getGender(entityContexts);
            if (gender == null) continue;
            if (gender == GenderEnum.MALE) {
                males.addAll(entityContexts);
                continue;
            }
            if (gender == GenderEnum.FEMALE) {
                females.addAll(entityContexts);
                continue;
            }
            if (gender != GenderEnum.NEUTER) continue;
            eunuches.addAll(entityContexts);
        }
        for (Context ec : singletons) {
            GenderEnum gender = this.getGender(ec);
            if (gender == GenderEnum.MALE) {
                males.add(ec);
                continue;
            }
            if (gender == GenderEnum.FEMALE) {
                females.add(ec);
                continue;
            }
            if (gender != GenderEnum.NEUTER) continue;
            eunuches.add(ec);
        }
        for (Context ec : males) {
            this.addEvent(GenderEnum.MALE.toString(), ec);
        }
        for (Context ec : females) {
            this.addEvent(GenderEnum.FEMALE.toString(), ec);
        }
        for (Context ec : eunuches) {
            this.addEvent(GenderEnum.NEUTER.toString(), ec);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: GenderModel modelName < tiger/NN bear/NN");
            System.exit(1);
        }
        String modelName = args[0];
        GenderModel model = new GenderModel(modelName, false);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        while (line != null) {
            String[] words = line.split(" ");
            double[] dist = model.genderDistribution(Context.parseContext(words[0]));
            System.out.println("m=" + dist[model.getMaleIndex()] + " f=" + dist[model.getFemaleIndex()] + " n=" + dist[model.getNeuterIndex()] + " " + model.getFeatures(Context.parseContext(words[0])));
            line = in.readLine();
        }
    }

    @Override
    public double[] genderDistribution(Context np1) {
        List<String> features = this.getFeatures(np1);
        if (this.debugOn) {
            // empty if block
        }
        return this.testModel.eval(features.toArray(new String[features.size()]));
    }

    @Override
    public void trainModel() throws IOException {
        if (this.debugOn) {
            FileWriter writer = new FileWriter(this.modelName + ".events");
            for (Event e : this.events) {
                writer.write(e.toString() + "\n");
            }
            writer.close();
        }
        new SuffixSensitiveGISModelWriter((AbstractModel)GIS.trainModel((EventStream)new CollectionEventStream(this.events), (boolean)true), new File(this.modelName + this.modelExtension)).persist();
    }

    @Override
    public int getFemaleIndex() {
        return this.femaleIndex;
    }

    @Override
    public int getMaleIndex() {
        return this.maleIndex;
    }

    @Override
    public int getNeuterIndex() {
        return this.neuterIndex;
    }
}

