/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.interpolation.InterpolationPostProcessor;
import org.codehaus.plexus.interpolation.util.ValueSourceUtils;

public class PathTranslatingPostProcessor
implements InterpolationPostProcessor {
    private final List unprefixedPathKeys;
    private final File projectDir;
    private final PathTranslator pathTranslator;
    private final List expressionPrefixes;

    public PathTranslatingPostProcessor(List expressionPrefixes, List unprefixedPathKeys, File projectDir, PathTranslator pathTranslator) {
        this.expressionPrefixes = expressionPrefixes;
        this.unprefixedPathKeys = unprefixedPathKeys;
        this.projectDir = projectDir;
        this.pathTranslator = pathTranslator;
    }

    public Object execute(String expression, Object value) {
        expression = ValueSourceUtils.trimPrefix((String)expression, (Collection)this.expressionPrefixes, (boolean)true);
        if (this.projectDir != null && value != null && this.unprefixedPathKeys.contains(expression)) {
            return this.pathTranslator.alignToBaseDirectory(String.valueOf(value), this.projectDir);
        }
        return value;
    }
}

