/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Notifier
implements Serializable,
InputLocationTracker {
    final String type;
    final boolean sendOnError;
    final boolean sendOnFailure;
    final boolean sendOnSuccess;
    final boolean sendOnWarning;
    final String address;
    final Map<String, String> configuration;
    final Map<Object, InputLocation> locations;

    Notifier(String type, boolean sendOnError, boolean sendOnFailure, boolean sendOnSuccess, boolean sendOnWarning, String address, Map<String, String> configuration, Map<Object, InputLocation> locations) {
        this.type = type;
        this.sendOnError = sendOnError;
        this.sendOnFailure = sendOnFailure;
        this.sendOnSuccess = sendOnSuccess;
        this.sendOnWarning = sendOnWarning;
        this.address = address;
        this.configuration = ImmutableCollections.copy(configuration);
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getType() {
        return this.type;
    }

    public boolean isSendOnError() {
        return this.sendOnError;
    }

    public boolean isSendOnFailure() {
        return this.sendOnFailure;
    }

    public boolean isSendOnSuccess() {
        return this.sendOnSuccess;
    }

    public boolean isSendOnWarning() {
        return this.sendOnWarning;
    }

    public String getAddress() {
        return this.address;
    }

    @Nonnull
    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Notifier.newBuilder(this);
    }

    @Nonnull
    public Notifier withType(String type) {
        return Notifier.newBuilder(this, true).type(type).build();
    }

    @Nonnull
    public Notifier withSendOnError(boolean sendOnError) {
        return Notifier.newBuilder(this, true).sendOnError(sendOnError).build();
    }

    @Nonnull
    public Notifier withSendOnFailure(boolean sendOnFailure) {
        return Notifier.newBuilder(this, true).sendOnFailure(sendOnFailure).build();
    }

    @Nonnull
    public Notifier withSendOnSuccess(boolean sendOnSuccess) {
        return Notifier.newBuilder(this, true).sendOnSuccess(sendOnSuccess).build();
    }

    @Nonnull
    public Notifier withSendOnWarning(boolean sendOnWarning) {
        return Notifier.newBuilder(this, true).sendOnWarning(sendOnWarning).build();
    }

    @Nonnull
    public Notifier withAddress(String address) {
        return Notifier.newBuilder(this, true).address(address).build();
    }

    @Nonnull
    public Notifier withConfiguration(Map<String, String> configuration) {
        return Notifier.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static Notifier newInstance() {
        return Notifier.newInstance(true);
    }

    @Nonnull
    public static Notifier newInstance(boolean withDefaults) {
        return Notifier.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Notifier.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Notifier from) {
        return Notifier.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Notifier from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Notifier base;
        String type;
        Boolean sendOnError;
        Boolean sendOnFailure;
        Boolean sendOnSuccess;
        Boolean sendOnWarning;
        String address;
        Map<String, String> configuration;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                this.type = "mail";
                this.sendOnError = true;
                this.sendOnFailure = true;
                this.sendOnSuccess = true;
                this.sendOnWarning = true;
            }
        }

        Builder(Notifier base, boolean forceCopy) {
            if (forceCopy) {
                this.type = base.type;
                this.sendOnError = base.sendOnError;
                this.sendOnFailure = base.sendOnFailure;
                this.sendOnSuccess = base.sendOnSuccess;
                this.sendOnWarning = base.sendOnWarning;
                this.address = base.address;
                this.configuration = base.configuration;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder sendOnError(boolean sendOnError) {
            this.sendOnError = sendOnError;
            return this;
        }

        @Nonnull
        public Builder sendOnFailure(boolean sendOnFailure) {
            this.sendOnFailure = sendOnFailure;
            return this;
        }

        @Nonnull
        public Builder sendOnSuccess(boolean sendOnSuccess) {
            this.sendOnSuccess = sendOnSuccess;
            return this;
        }

        @Nonnull
        public Builder sendOnWarning(boolean sendOnWarning) {
            this.sendOnWarning = sendOnWarning;
            return this;
        }

        @Nonnull
        public Builder address(String address) {
            this.address = address;
            return this;
        }

        @Nonnull
        public Builder configuration(Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Notifier build() {
            if (!(this.base == null || this.type != null && this.type != this.base.type || this.sendOnError != null && this.sendOnError != this.base.sendOnError || this.sendOnFailure != null && this.sendOnFailure != this.base.sendOnFailure || this.sendOnSuccess != null && this.sendOnSuccess != this.base.sendOnSuccess || this.sendOnWarning != null && this.sendOnWarning != this.base.sendOnWarning || this.address != null && this.address != this.base.address || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("type", newlocs.containsKey("type") ? (InputLocation)newlocs.get("type") : (InputLocation)oldlocs.get("type"));
            locations.put("sendOnError", newlocs.containsKey("sendOnError") ? (InputLocation)newlocs.get("sendOnError") : (InputLocation)oldlocs.get("sendOnError"));
            locations.put("sendOnFailure", newlocs.containsKey("sendOnFailure") ? (InputLocation)newlocs.get("sendOnFailure") : (InputLocation)oldlocs.get("sendOnFailure"));
            locations.put("sendOnSuccess", newlocs.containsKey("sendOnSuccess") ? (InputLocation)newlocs.get("sendOnSuccess") : (InputLocation)oldlocs.get("sendOnSuccess"));
            locations.put("sendOnWarning", newlocs.containsKey("sendOnWarning") ? (InputLocation)newlocs.get("sendOnWarning") : (InputLocation)oldlocs.get("sendOnWarning"));
            locations.put("address", newlocs.containsKey("address") ? (InputLocation)newlocs.get("address") : (InputLocation)oldlocs.get("address"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            return new Notifier(this.type != null ? this.type : (this.base != null ? this.base.type : null), this.sendOnError != null ? this.sendOnError : (this.base != null ? this.base.sendOnError : true), this.sendOnFailure != null ? this.sendOnFailure : (this.base != null ? this.base.sendOnFailure : true), this.sendOnSuccess != null ? this.sendOnSuccess : (this.base != null ? this.base.sendOnSuccess : true), this.sendOnWarning != null ? this.sendOnWarning : (this.base != null ? this.base.sendOnWarning : true), this.address != null ? this.address : (this.base != null ? this.base.address : null), this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null), locations);
        }
    }
}

