/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Extension
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final XmlNode configuration;
    final Map<Object, InputLocation> locations;

    Extension(String groupId, String artifactId, String version, XmlNode configuration, Map<Object, InputLocation> locations) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.configuration = configuration;
        this.locations = ImmutableCollections.copy(locations);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Nonnull
    public Builder with() {
        return Extension.newBuilder(this);
    }

    @Nonnull
    public Extension withGroupId(String groupId) {
        return Extension.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Extension withArtifactId(String artifactId) {
        return Extension.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Extension withVersion(String version) {
        return Extension.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Extension withConfiguration(XmlNode configuration) {
        return Extension.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static Extension newInstance() {
        return Extension.newInstance(true);
    }

    @Nonnull
    public static Extension newInstance(boolean withDefaults) {
        return Extension.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Extension.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Extension from) {
        return Extension.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Extension from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Extension)) {
            return false;
        }
        Extension e = (Extension)o;
        return Objects.equals(e.getArtifactId(), this.getArtifactId()) && Objects.equals(e.getGroupId(), this.getGroupId()) && Objects.equals(e.getVersion(), this.getVersion());
    }

    public int hashCode() {
        return Objects.hash(this.getArtifactId(), this.getGroupId(), this.getVersion());
    }

    @NotThreadSafe
    public static class Builder {
        Extension base;
        String groupId;
        String artifactId;
        String version;
        XmlNode configuration;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(Extension base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.configuration = base.configuration;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Extension build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("groupId", newlocs.containsKey("groupId") ? (InputLocation)newlocs.get("groupId") : (InputLocation)oldlocs.get("groupId"));
            locations.put("artifactId", newlocs.containsKey("artifactId") ? (InputLocation)newlocs.get("artifactId") : (InputLocation)oldlocs.get("artifactId"));
            locations.put("version", newlocs.containsKey("version") ? (InputLocation)newlocs.get("version") : (InputLocation)oldlocs.get("version"));
            locations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
            return new Extension(this.groupId != null ? this.groupId : (this.base != null ? this.base.groupId : null), this.artifactId != null ? this.artifactId : (this.base != null ? this.base.artifactId : null), this.version != null ? this.version : (this.base != null ? this.base.version : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), locations);
        }
    }
}

