/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtils {
    private static final Logger log = LoggerFactory.getLogger(TestUtils.class);
    public static final Random SEEDED_RANDOM = new Random(192348092834L);
    public static final String LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    public static final String DIGITS = "0123456789";
    public static final String LETTERS_AND_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final long DEFAULT_POLL_INTERVAL_MS = 100L;
    private static final long DEFAULT_MAX_WAIT_MS = 15000L;

    public static File tempFile() throws IOException {
        File file = Files.createTempFile("kafka", ".tmp", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        return file;
    }

    public static String randomString(int len) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            b.append(LETTERS_AND_DIGITS.charAt(SEEDED_RANDOM.nextInt(LETTERS_AND_DIGITS.length())));
        }
        return b.toString();
    }

    static File tempDirectory() {
        File file;
        String prefix = "kafka-";
        try {
            file = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to create a temp dir", ex);
        }
        Exit.addShutdownHook((String)"delete-temp-file-shutdown-hook", () -> {
            try {
                Utils.delete((File)file);
            }
            catch (IOException e) {
                log.error("Error deleting {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        });
        return file;
    }

    public static void waitForCondition(Supplier<Boolean> testCondition, String conditionDetails) throws InterruptedException {
        TestUtils.waitForCondition(testCondition, 15000L, conditionDetails);
    }

    public static void waitForCondition(Supplier<Boolean> testCondition, long maxWaitMs, String conditionDetails) throws InterruptedException {
        long expectedEnd = System.currentTimeMillis() + maxWaitMs;
        while (true) {
            block6: {
                try {
                    if (testCondition.get().booleanValue()) {
                        return;
                    }
                    String conditionDetail = conditionDetails == null ? "" : conditionDetails;
                    throw new TimeoutException("Condition not met: " + conditionDetail);
                }
                catch (AssertionError t) {
                    if (expectedEnd <= System.currentTimeMillis()) {
                        throw t;
                    }
                }
                catch (Exception e) {
                    if (expectedEnd > System.currentTimeMillis()) break block6;
                    throw new AssertionError(String.format("Assertion failed with an exception after %s ms", maxWaitMs), e);
                }
            }
            Thread.sleep(Math.min(100L, maxWaitMs));
        }
    }

    public static int waitUntilLeaderIsElectedOrChangedWithAdmin(Admin admin, String topic, int partitionNumber, long timeoutMs) throws Exception {
        BiFunction<String, Integer, Optional<Integer>> getPartitionLeader = (t, p) -> {
            try {
                return Optional.ofNullable(TestUtils.getLeaderFromAdmin(admin, t, p));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return TestUtils.doWaitUntilLeaderIsElectedOrChanged(getPartitionLeader, topic, partitionNumber, timeoutMs);
    }

    private static Integer getLeaderFromAdmin(Admin admin, String topic, int partition) throws Exception {
        TopicDescription topicDescription = (TopicDescription)((Map)admin.describeTopics(Collections.singletonList(topic)).allTopicNames().get()).get(topic);
        return topicDescription.partitions().stream().filter(partitionInfo -> partitionInfo.partition() == partition).findFirst().map(partitionInfo -> partitionInfo.leader().id() == Node.noNode().id() ? null : Integer.valueOf(partitionInfo.leader().id())).orElse(null);
    }

    private static int doWaitUntilLeaderIsElectedOrChanged(BiFunction<String, Integer, Optional<Integer>> getPartitionLeader, String topic, int partition, long timeoutMs) throws Exception {
        long startTime = System.currentTimeMillis();
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        Optional<Object> electedLeader = Optional.empty();
        while (electedLeader.isEmpty() && System.currentTimeMillis() < startTime + timeoutMs) {
            Optional<Integer> leader = getPartitionLeader.apply(topic, partition);
            if (leader.isPresent()) {
                log.trace("Leader {} is elected for partition {}", (Object)leader.get(), (Object)topicPartition);
                electedLeader = leader;
            } else {
                log.trace("Leader for partition {} is not elected yet", (Object)topicPartition);
            }
            Thread.sleep(Math.min(timeoutMs, 100L));
        }
        Optional finalLeader = electedLeader;
        return (Integer)electedLeader.orElseThrow(() -> new AssertionError((Object)("Timing out after " + timeoutMs + " ms since a leader was not elected for partition " + String.valueOf(topicPartition) + ", leader is " + String.valueOf(finalLeader))));
    }
}

