/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKeyValueStore
implements KeyValueStore<Bytes, byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryKeyValueStore.class);
    private final String name;
    private final NavigableMap<Bytes, byte[]> map = new TreeMap<Bytes, byte[]>();
    private volatile boolean open = false;

    public InMemoryKeyValueStore(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Deprecated
    public void init(ProcessorContext context, StateStore root) {
        if (root != null) {
            context.register(root, (key, value) -> this.put(Bytes.wrap((byte[])key), value));
        }
        this.open = true;
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public synchronized byte[] get(Bytes key) {
        return (byte[])this.map.get(key);
    }

    @Override
    public synchronized void put(Bytes key, byte[] value) {
        this.putInternal(key, value);
    }

    @Override
    public synchronized byte[] putIfAbsent(Bytes key, byte[] value) {
        byte[] originalValue = this.get(key);
        if (originalValue == null) {
            this.put(key, value);
        }
        return originalValue;
    }

    private void putInternal(Bytes key, byte[] value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    @Override
    public synchronized void putAll(List<KeyValue<Bytes, byte[]>> entries) {
        for (KeyValue<Bytes, byte[]> entry : entries) {
            this.putInternal((Bytes)entry.key, (byte[])entry.value);
        }
    }

    @Override
    public <PS extends Serializer<P>, P> KeyValueIterator<Bytes, byte[]> prefixScan(P prefix, PS prefixKeySerializer) {
        Bytes from = Bytes.wrap((byte[])prefixKeySerializer.serialize(null, prefix));
        Bytes to = Bytes.increment((Bytes)from);
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.subMap(from, true, to, false).keySet(), true));
    }

    @Override
    public synchronized byte[] delete(Bytes key) {
        return (byte[])this.map.remove(key);
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to) {
        return this.range(from, to, true);
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> reverseRange(Bytes from, Bytes to) {
        return this.range(from, to, false);
    }

    private KeyValueIterator<Bytes, byte[]> range(Bytes from, Bytes to, boolean forward) {
        if (from == null && to == null) {
            return this.getKeyValueIterator(this.map.keySet(), forward);
        }
        if (from == null) {
            return this.getKeyValueIterator(this.map.headMap(to, true).keySet(), forward);
        }
        if (to == null) {
            return this.getKeyValueIterator(this.map.tailMap(from, true).keySet(), forward);
        }
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to range arguments set in the wrong order, or serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        return this.getKeyValueIterator(this.map.subMap(from, true, to, true).keySet(), forward);
    }

    private KeyValueIterator<Bytes, byte[]> getKeyValueIterator(Set<Bytes> rangeSet, boolean forward) {
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(rangeSet, forward));
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> all() {
        return this.range(null, null);
    }

    @Override
    public synchronized KeyValueIterator<Bytes, byte[]> reverseAll() {
        return new DelegatingPeekingKeyValueIterator<Bytes, byte[]>(this.name, new InMemoryKeyValueIterator(this.map.keySet(), false));
    }

    @Override
    public long approximateNumEntries() {
        return this.map.size();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.map.clear();
        this.open = false;
    }

    private class InMemoryKeyValueIterator
    implements KeyValueIterator<Bytes, byte[]> {
        private final Iterator<Bytes> iter;

        private InMemoryKeyValueIterator(Set<Bytes> keySet, boolean forward) {
            this.iter = forward ? new TreeSet<Bytes>(keySet).iterator() : new TreeSet<Bytes>(keySet).descendingIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public KeyValue<Bytes, byte[]> next() {
            Bytes key = this.iter.next();
            return new KeyValue<Bytes, byte[]>(key, (byte[])InMemoryKeyValueStore.this.map.get(key));
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            throw new UnsupportedOperationException("peekNextKey() not supported in " + this.getClass().getName());
        }
    }
}

